/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HttpClientUtil;
import HTTPClient.NVPair;

public class HttpHeaderElement {
    private String name;
    private String value;
    private NVPair[] parameters;

    public HttpHeaderElement(String name) {
        this.name = name;
        this.value = null;
        this.parameters = new NVPair[0];
    }

    public HttpHeaderElement(String name, String value, NVPair[] params) {
        this.name = name;
        this.value = value;
        if (params != null) {
            this.parameters = new NVPair[params.length];
            System.arraycopy(params, 0, this.parameters, 0, params.length);
        } else {
            this.parameters = new NVPair[0];
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NVPair[] getParams() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof HttpHeaderElement) {
            String other = ((HttpHeaderElement)obj).name;
            return this.name.equalsIgnoreCase(other);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.appendTo(buf);
        return buf.toString();
    }

    public void appendTo(StringBuffer buf) {
        buf.append(this.name);
        if (this.value != null) {
            if (HttpClientUtil.needsQuoting(this.value)) {
                buf.append("=\"");
                buf.append(HttpClientUtil.quoteString(this.value, "\\\""));
                buf.append('\"');
            } else {
                buf.append('=');
                buf.append(this.value);
            }
        }
        for (int idx = 0; idx < this.parameters.length; ++idx) {
            buf.append(";");
            buf.append(this.parameters[idx].getName());
            String pval = this.parameters[idx].getValue();
            if (pval == null) continue;
            if (HttpClientUtil.needsQuoting(pval)) {
                buf.append("=\"");
                buf.append(HttpClientUtil.quoteString(pval, "\\\""));
                buf.append('\"');
                continue;
            }
            buf.append('=');
            buf.append(pval);
        }
    }
}

