/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.DataChainInputStreamQueueEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

final class DataChainInputStreamImplementation
extends InputStream {
    private boolean m_closed = false;
    DataChainInputStreamQueueEntry m_queueEntriesHead = null;
    DataChainInputStreamQueueEntry m_queueEntriesTail = null;
    Object m_oSync = new Object();

    DataChainInputStreamImplementation() {
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int bytesRead = 0;
        while ((bytesRead = this.read(buffer)) == 0) {
        }
        int returnedByte = -1;
        if (bytesRead == 1) {
            returnedByte = buffer[0] & 0xFF;
        }
        return returnedByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] a_buffer, int a_offset, int a_length) throws IOException {
        int bytesRead = 0;
        if (a_buffer.length < a_offset) {
            a_offset = a_buffer.length;
        }
        if (a_buffer.length < a_offset + a_length) {
            a_length = a_buffer.length - a_offset;
        }
        if (a_length > 0) {
            Object object = this.m_oSync;
            synchronized (object) {
                if (this.m_closed) {
                    throw new IOException("Stream is closed.");
                }
                while (this.m_queueEntriesHead == null) {
                    if (this.m_closed) {
                        throw new IOException("Stream is closed.");
                    }
                    try {
                        this.m_oSync.wait();
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException("InterruptedException: " + e.toString());
                    }
                }
                switch (this.m_queueEntriesHead.getType()) {
                    case 2: {
                        bytesRead = -1;
                        break;
                    }
                    case 1: {
                        while (this.m_queueEntriesHead != null && this.m_queueEntriesHead.getType() == 1 && bytesRead < a_length) {
                            int bytesToRead = Math.min(a_length - bytesRead, this.m_queueEntriesHead.getAvailableBytes());
                            this.m_queueEntriesHead.getData(a_buffer, a_offset + bytesRead, bytesToRead);
                            bytesRead += bytesToRead;
                            if (this.m_queueEntriesHead.getAvailableBytes() != 0) continue;
                            this.m_queueEntriesHead = this.m_queueEntriesHead.m_Next;
                            if (this.m_queueEntriesHead != null) continue;
                            this.m_queueEntriesTail = null;
                        }
                        break;
                    }
                    case 3: {
                        IOException exceptionToThrow = this.m_queueEntriesHead.getIOException();
                        this.m_queueEntriesHead = this.m_queueEntriesHead.m_Next;
                        if (this.m_queueEntriesHead == null) {
                            this.m_queueEntriesTail = null;
                        }
                        if (exceptionToThrow == null) break;
                        throw exceptionToThrow;
                    }
                }
            }
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() throws IOException {
        int availableBytes = 0;
        Object object = this.m_oSync;
        synchronized (object) {
            if (this.m_closed) {
                throw new IOException("Stream is closed.");
            }
            DataChainInputStreamQueueEntry currentEntry = this.m_queueEntriesHead;
            while (currentEntry != null) {
                if (currentEntry.getType() == 1) {
                    availableBytes += currentEntry.getAvailableBytes();
                    currentEntry = currentEntry.m_Next;
                    continue;
                }
                currentEntry = null;
            }
        }
        return availableBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.m_closed) {
            Object object = this.m_oSync;
            synchronized (object) {
                this.m_closed = true;
                this.m_queueEntriesHead = null;
                this.m_queueEntriesTail = null;
                this.m_oSync.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(DataChainInputStreamQueueEntry a_entry) {
        if (a_entry.getType() == 1 && a_entry.getAvailableBytes() == 0) {
            return;
        }
        Object object = this.m_oSync;
        synchronized (object) {
            if (this.m_closed) {
                return;
            }
            if (this.m_queueEntriesTail != null && this.m_queueEntriesTail.getType() == 2) {
                return;
            }
            a_entry.m_Next = null;
            if (this.m_queueEntriesTail != null) {
                this.m_queueEntriesTail.m_Next = a_entry;
                this.m_queueEntriesTail = a_entry;
            } else {
                this.m_queueEntriesTail = a_entry;
                this.m_queueEntriesHead = a_entry;
            }
            this.m_oSync.notifyAll();
        }
    }
}

