/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.MyRSA;
import anon.crypto.MyRSAPublicKey;
import anon.util.Base64;
import anon.util.IMiscPasswordReader;
import anon.util.SingleStringPasswordReader;
import anon.util.XMLUtil;
import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.modes.CTSBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLEncryption {
    public static final String XML_ELEMENT_NAME = "EncryptedData";
    private static final int SALT_SIZE = 20;
    private static final int MIN_ITERATIONS = 1000;

    private XMLEncryption() {
    }

    public static Element encryptElement(Element elemPlain, String password) throws Exception {
        SecureRandom random = new SecureRandom();
        byte[] kSalt = new byte[20];
        random.nextBytes(kSalt);
        byte[] barInput = null;
        byte[] barOutput = null;
        try {
            barInput = XMLUtil.toString(elemPlain).getBytes();
            barOutput = XMLEncryption.codeDataCTS(true, barInput, XMLEncryption.generatePBEKey(password, kSalt));
        }
        catch (Exception ex1) {
            throw new IOException("Exception while encrypting: " + ex1.toString());
        }
        Document doc = elemPlain.getOwnerDocument();
        Node nodeParent = elemPlain.getParentNode();
        Element elemCrypt = doc.createElement(XML_ELEMENT_NAME);
        elemCrypt.setAttribute("Type", "http://www.w3.org/2001/04/xmlenc#Element");
        elemCrypt.setAttribute("xmlns", "http://www.w3.org/2001/04/xmlenc#");
        Element elemAlgo = doc.createElement("EncryptionMethod");
        elemAlgo.setAttribute("Algorithm", "aes-cts");
        elemCrypt.appendChild(elemAlgo);
        Element elemKeyInfo = doc.createElement("ds:KeyInfo");
        elemKeyInfo.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        Element elemSalt = doc.createElement("ds:Salt");
        XMLUtil.setValue((Node)elemSalt, Base64.encodeBytes(kSalt));
        elemKeyInfo.appendChild(elemSalt);
        elemCrypt.appendChild(elemKeyInfo);
        Element elemCipher = doc.createElement("CipherData");
        elemCrypt.appendChild(elemCipher);
        Element elemValue = doc.createElement("CipherValue");
        elemCipher.appendChild(elemValue);
        XMLUtil.setValue((Node)elemValue, Base64.encodeBytes(barOutput));
        nodeParent.removeChild(elemPlain);
        nodeParent.appendChild(elemCrypt);
        return elemCrypt;
    }

    private static CipherParameters generatePBEKey(String password, byte[] kSalt) {
        PKCS12PBEParams kParams = new PKCS12PBEParams(kSalt, 1000);
        PKCS12ParametersGenerator paramGen = new PKCS12ParametersGenerator(new SHA1Digest());
        paramGen.init(PBEParametersGenerator.PKCS12PasswordToBytes(password.toCharArray()), kParams.getIV(), kParams.getIterations().intValue());
        return paramGen.generateDerivedParameters(128);
    }

    private static byte[] codeDataCTS(boolean encrypt, byte[] barInput, CipherParameters params) throws Exception {
        CTSBlockCipher cipher = new CTSBlockCipher(new AESFastEngine());
        cipher.init(encrypt, params);
        byte[] barOutput = new byte[((BufferedBlockCipher)cipher).getOutputSize(barInput.length)];
        int len = 0;
        if (barInput.length != 0) {
            len = ((BufferedBlockCipher)cipher).processBytes(barInput, 0, barInput.length, barOutput, 0);
        }
        ((BufferedBlockCipher)cipher).doFinal(barOutput, len);
        return barOutput;
    }

    private static byte[] codeDataCBCwithHMAC(boolean encrypt, byte[] barInput, CipherParameters encKey, CipherParameters macKey) throws Exception {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new AESFastEngine()));
        cipher.init(encrypt, encKey);
        byte[] barOutput = new byte[cipher.getOutputSize(barInput.length)];
        int len = 0;
        if (barInput.length != 0) {
            len = cipher.processBytes(barInput, 0, barInput.length, barOutput, 0);
        }
        len += cipher.doFinal(barOutput, len);
        if (!encrypt && len != barOutput.length) {
            byte[] tmp = new byte[len];
            System.arraycopy(barOutput, 0, tmp, 0, len);
            barOutput = tmp;
        }
        return barOutput;
    }

    public static Element decryptElement(Element elemCrypt, String password) throws Exception {
        return XMLEncryption.decryptElement(elemCrypt, new SingleStringPasswordReader(password));
    }

    public static Element decryptElement(Element elemCrypt, IMiscPasswordReader a_passwordReader) throws Exception {
        String password;
        String strType;
        Document doc = elemCrypt.getOwnerDocument();
        Node nodeParent = elemCrypt.getParentNode();
        if (a_passwordReader == null) {
            a_passwordReader = new SingleStringPasswordReader("");
        }
        if ((strType = elemCrypt.getAttribute("Type")) == null || !strType.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            throw new IOException("Wrong XML Format");
        }
        Element elemValue = (Element)XMLUtil.getFirstChildByName(elemCrypt, "CipherData");
        elemValue = (Element)XMLUtil.getFirstChildByName(elemValue, "CipherValue");
        byte[] barInput = Base64.decode(XMLUtil.parseValue((Node)elemValue, (String)null));
        Element elemKeyInfo = (Element)XMLUtil.getFirstChildByName(elemCrypt, "ds:KeyInfo");
        Element elemSalt = (Element)XMLUtil.getFirstChildByName(elemKeyInfo, "ds:Salt");
        byte[] barSalt = Base64.decode(XMLUtil.parseValue((Node)elemSalt, (String)null));
        byte[] barOutput = null;
        Document doc2 = null;
        Element elemPlain = null;
        Exception ex = null;
        while ((password = a_passwordReader.readPassword(null)) != null) {
            try {
                barOutput = XMLEncryption.codeDataCTS(false, barInput, XMLEncryption.generatePBEKey(password, barSalt));
                doc2 = XMLUtil.toXMLDocument(barOutput);
                elemPlain = (Element)XMLUtil.importNode(doc, doc2.getDocumentElement(), true);
                ex = null;
                break;
            }
            catch (Exception a_e) {
                ex = a_e;
            }
        }
        if (ex != null) {
            throw new IOException("Exception while decrypting (maybe password wrong): " + ex.toString());
        }
        nodeParent.removeChild(elemCrypt);
        nodeParent.appendChild(elemPlain);
        return elemPlain;
    }

    public static boolean encryptElement(Element elemPlain, MyRSAPublicKey publicKey) {
        Node elemCrypt = XMLEncryption.getEncryptedElement(elemPlain, publicKey);
        if (elemCrypt == null) {
            return false;
        }
        Node nodeParent = elemPlain.getParentNode();
        nodeParent.removeChild(elemPlain);
        nodeParent.appendChild(elemCrypt);
        return true;
    }

    public static Node getEncryptedElement(Element elemPlain, MyRSAPublicKey publicKey) {
        byte[] encryptedKey;
        byte[] keyAndIv = new byte[32];
        SecureRandom sec = new SecureRandom();
        sec.nextBytes(keyAndIv);
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(keyAndIv, 0, 16), keyAndIv, 16, 16);
        byte[] barInput = null;
        byte[] barOutput = null;
        try {
            barInput = XMLUtil.toString(elemPlain).getBytes();
            barOutput = XMLEncryption.codeDataCBCwithHMAC(true, barInput, params, null);
        }
        catch (Exception ex1) {
            return null;
        }
        MyRSA rsa = new MyRSA();
        try {
            rsa.init(publicKey);
            encryptedKey = rsa.processBlockOAEP(keyAndIv, 0, keyAndIv.length);
        }
        catch (Exception ex) {
            return null;
        }
        Document doc = elemPlain.getOwnerDocument();
        Element elemCrypt = doc.createElement(XML_ELEMENT_NAME);
        elemCrypt.setAttribute("Type", "http://www.w3.org/2001/04/xmlenc#Element");
        elemCrypt.setAttribute("xmlns", "http://www.w3.org/2001/04/xmlenc#");
        Element elemAlgo = doc.createElement("EncryptionMethod");
        elemAlgo.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        elemCrypt.appendChild(elemAlgo);
        Element elemKeyInfo = doc.createElement("ds:KeyInfo");
        elemKeyInfo.setAttribute("xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        elemCrypt.appendChild(elemKeyInfo);
        Element elemEncKey = doc.createElement("EncryptedKey");
        elemKeyInfo.appendChild(elemEncKey);
        elemAlgo = doc.createElement("EncryptionMethod");
        elemAlgo.setAttribute("Algorithm", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        elemEncKey.appendChild(elemAlgo);
        Element elemCipher = doc.createElement("CipherData");
        elemEncKey.appendChild(elemCipher);
        Element elemValue = doc.createElement("CipherValue");
        elemCipher.appendChild(elemValue);
        XMLUtil.setValue((Node)elemValue, Base64.encodeBytes(encryptedKey));
        elemCipher = doc.createElement("CipherData");
        elemCrypt.appendChild(elemCipher);
        elemValue = doc.createElement("CipherValue");
        elemCipher.appendChild(elemValue);
        XMLUtil.setValue((Node)elemValue, Base64.encodeBytes(barOutput));
        return elemCrypt;
    }
}

