/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls.util;

import anon.crypto.tinytls.util.P_Hash;
import anon.util.ByteArrayUtil;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class PRF {
    private byte[] m_secret;
    private byte[] m_seed;
    private byte[] m_label;

    public PRF(byte[] secret, byte[] label, byte[] seed) {
        this.m_secret = secret;
        this.m_seed = seed;
        this.m_label = label;
    }

    public byte[] calculate(int length) {
        byte[] c = new byte[length];
        int splitsize = this.m_secret.length / 2;
        if (splitsize * 2 < this.m_secret.length) {
            ++splitsize;
        }
        byte[] s1 = ByteArrayUtil.copy(this.m_secret, 0, splitsize);
        byte[] s2 = ByteArrayUtil.copy(this.m_secret, this.m_secret.length - splitsize, splitsize);
        P_Hash phash = new P_Hash(s1, ByteArrayUtil.conc(this.m_label, this.m_seed), new MD5Digest());
        byte[] a = phash.getHash(length);
        phash = new P_Hash(s2, ByteArrayUtil.conc(this.m_label, this.m_seed), new SHA1Digest());
        byte[] b = phash.getHash(length);
        for (int i = 0; i < length; ++i) {
            c[i] = (byte)((a[i] ^ b[i]) & 0xFF);
        }
        return c;
    }
}

