/*
 * Decompiled with CFR 0.152.
 */
package com.skype;

import com.skype.Application;
import com.skype.SkypeException;
import com.skype.SkypeExceptionHandler;
import com.skype.User;
import com.skype.Utils;

public final class Skype {
    public static final String LIBRARY_VERSION = "1.0.0.0";
    private static SkypeExceptionHandler defaultExceptionHandler;
    private static SkypeExceptionHandler exceptionHandler;

    public static String getVersion() throws SkypeException {
        return Utils.getProperty("SKYPEVERSION");
    }

    public static Application addApplication(String name) throws SkypeException {
        Utils.checkNotNull("name", name);
        return Application.getInstance(name);
    }

    public static User getUser(String id) {
        return User.getInstance(id);
    }

    public static void setSkypeExceptionHandler(SkypeExceptionHandler handler) {
        if (handler == null) {
            handler = defaultExceptionHandler;
        }
        exceptionHandler = handler;
    }

    static void handleUncaughtException(Throwable e) {
        exceptionHandler.uncaughtExceptionHappened(e);
    }

    private Skype() {
    }

    static {
        exceptionHandler = defaultExceptionHandler = new SkypeExceptionHandler(){

            public void uncaughtExceptionHappened(Throwable e) {
            }
        };
    }
}

