/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos;

import infoservice.agreement.paxos.PaxosInstance;
import infoservice.agreement.paxos.PaxosObject;
import infoservice.agreement.paxos.PaxosRound;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PaxosExecution
extends PaxosObject {
    private String m_initiator;
    private Hashtable m_rounds = new Hashtable();
    private PaxosInstance m_paxosInstance;
    private Vector m_roundLeaders = new Vector();
    private boolean m_decided = false;

    public PaxosExecution(PaxosInstance a_instance, String a_initiator, Vector a_roundLeaders) {
        this.m_initiator = a_initiator;
        this.m_paxosInstance = a_instance;
        this.m_roundLeaders = a_roundLeaders;
        this.createRound();
    }

    public PaxosRound getRound(int a_round) {
        PaxosRound result = (PaxosRound)this.m_rounds.get(new Integer(a_round));
        return result;
    }

    public PaxosRound createRound(int a_round) {
        PaxosRound result = new PaxosRound(this, a_round, this.getNextRoundLeader(a_round));
        this.m_rounds.put(new Integer(a_round), result);
        return result;
    }

    public PaxosRound createRound() {
        return this.createRound(0);
    }

    public String getInitiator() {
        return this.m_initiator;
    }

    public PaxosInstance getPaxosInstance() {
        return this.m_paxosInstance;
    }

    public void cancel() {
        Enumeration en = this.m_rounds.keys();
        while (en.hasMoreElements()) {
            PaxosRound tmp = (PaxosRound)this.m_rounds.get(en.nextElement());
            tmp.abort();
        }
    }

    public void decide(String a_proposal) {
        this.m_paxosInstance.addDecision(this.getInitiator(), a_proposal);
        this.m_decided = true;
    }

    public boolean isDecided() {
        return this.m_decided;
    }

    public String getNextRoundLeader(int a_round) {
        int i;
        for (i = 0; i < this.m_roundLeaders.size() && !this.getInitiator().equals(this.m_roundLeaders.get(i)); ++i) {
        }
        int index = (i + a_round) % this.m_roundLeaders.size();
        String g = (String)this.m_roundLeaders.get(index);
        return g;
    }

    public String getGoodProposal(int a_nextRound) {
        String goodValue = null;
        for (int i = 0; i < a_nextRound; ++i) {
            PaxosRound round = (PaxosRound)this.m_rounds.get(new Integer(i));
            if (round == null) {
                this.error("(acc) Uuuups, there is no round " + i);
                continue;
            }
            Vector acc = round.getAcc();
            if (acc.isEmpty()) continue;
            Enumeration en = acc.elements();
            while (en.hasMoreElements()) {
                String prop = (String)en.nextElement();
                boolean good = true;
                for (int j = i; j < a_nextRound; ++j) {
                    PaxosRound r = (PaxosRound)this.m_rounds.get(new Integer(j));
                    if (r == null) {
                        this.error("(poss) Uuuups, there is no round " + j);
                        continue;
                    }
                    Vector poss = r.getPoss();
                    if (poss.isEmpty() || poss.contains(prop)) continue;
                    good = false;
                    break;
                }
                if (!good) continue;
                goodValue = prop;
                break;
            }
            if (goodValue != null) break;
        }
        if (goodValue == null) {
            goodValue = "NULL";
        }
        return goodValue;
    }
}

