/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central;

import anon.infoservice.Database;
import infoservice.mailsystem.central.BannedMailAddressDBEntry;
import infoservice.mailsystem.central.CommandFactory;
import infoservice.mailsystem.central.MailAddressDBEntry;
import infoservice.mailsystem.central.MailContext;
import java.io.InputStream;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import logging.LogHolder;
import logging.LogType;

public class MailHandler {
    private MimeMessage m_receivedMessage;

    public MailHandler(InputStream a_receivedMail) throws MessagingException {
        this.m_receivedMessage = new MimeMessage(MailContext.getInstance().getSession(), a_receivedMail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void createReply() throws Exception {
        MimeMessage reply;
        String subject;
        Address[] replyAddresses = this.m_receivedMessage.getReplyTo();
        if (replyAddresses == null) {
            LogHolder.log(3, LogType.MISC, "MailHandler: createReply: Received request doesn't contain any addresses useable for creating a reply.");
            return;
        }
        Vector<Address> validReplyAddresses = new Vector<Address>();
        Vector<Address> warnReplyAddresses = new Vector<Address>();
        for (int i = 0; i < replyAddresses.length; ++i) {
            block10: {
                Address currentAddress;
                block11: {
                    currentAddress = replyAddresses[i];
                    if (currentAddress == null) continue;
                    Class<MailHandler> clazz = MailHandler.class;
                    // MONITORENTER : infoservice.mailsystem.central.MailHandler.class
                    if (validReplyAddresses.contains(currentAddress) || warnReplyAddresses.contains(currentAddress)) break block11;
                    if (Database.getInstance(BannedMailAddressDBEntry.class).getEntryById(currentAddress.toString()) == null) {
                        MailAddressDBEntry oldEntry = (MailAddressDBEntry)Database.getInstance(MailAddressDBEntry.class).getEntryById(currentAddress.toString());
                        Vector<Long> lastRequestTimes = null;
                        lastRequestTimes = oldEntry != null ? oldEntry.getRequestTimes() : new Vector<Long>();
                        while (lastRequestTimes.size() > 0 && (Long)lastRequestTimes.firstElement() < System.currentTimeMillis() - 600000L) {
                            lastRequestTimes.removeElementAt(0);
                        }
                        if (lastRequestTimes.size() >= 5) {
                            warnReplyAddresses.addElement(currentAddress);
                            Database.getInstance(BannedMailAddressDBEntry.class).update(new BannedMailAddressDBEntry(currentAddress));
                            LogHolder.log(6, LogType.MISC, "MailHandler: createReply: The reply address " + currentAddress.toString() + " is added to the ban-list and will receive a warning.");
                            break block10;
                        } else {
                            validReplyAddresses.addElement(currentAddress);
                            lastRequestTimes.addElement(new Long(System.currentTimeMillis()));
                            Database.getInstance(MailAddressDBEntry.class).update(new MailAddressDBEntry(currentAddress, lastRequestTimes));
                            LogHolder.log(7, LogType.MISC, "MailHandler: createReply: The reply address " + currentAddress.toString() + " is valid and will receive a reply.");
                        }
                        break block10;
                    } else {
                        LogHolder.log(7, LogType.MISC, "MailHandler: createReply: The reply address " + currentAddress.toString() + " is banned and will not receive anything.");
                    }
                    break block10;
                }
                LogHolder.log(7, LogType.MISC, "MailHandler: createReply: The reply address " + currentAddress.toString() + " was already handled within this request.");
            }
            // MONITOREXIT : clazz
        }
        if (validReplyAddresses.size() > 0) {
            LogHolder.log(7, LogType.MISC, "MailHandler: createReply: Create reply for valid recipients.");
            Object[] currentReplyAddresses = new Address[validReplyAddresses.size()];
            validReplyAddresses.copyInto(currentReplyAddresses);
            this.m_receivedMessage.setReplyTo((Address[])currentReplyAddresses);
            subject = this.m_receivedMessage.getSubject().trim();
            reply = (MimeMessage)this.m_receivedMessage.reply(false);
            CommandFactory.getCommandImplementation(subject, false).createReplyMessage(this.m_receivedMessage, reply);
            LogHolder.log(7, LogType.MISC, "MailHandler: createReply: Reply created. Starting transport to SMTP server.");
            Transport.send(reply);
            LogHolder.log(7, LogType.MISC, "MailHandler: createReply: Reply was sent.");
        }
        if (warnReplyAddresses.size() <= 0) return;
        LogHolder.log(7, LogType.MISC, "MailHandler: createReply: Create warning for recipients added to the ban-list.");
        Object[] currentReplyAddresses = new Address[warnReplyAddresses.size()];
        warnReplyAddresses.copyInto(currentReplyAddresses);
        this.m_receivedMessage.setReplyTo((Address[])currentReplyAddresses);
        subject = this.m_receivedMessage.getSubject().trim();
        reply = (MimeMessage)this.m_receivedMessage.reply(false);
        CommandFactory.getCommandImplementation(subject, true).createReplyMessage(this.m_receivedMessage, reply);
        LogHolder.log(7, LogType.MISC, "MailHandler: createReply: Ban warning created. Starting transport to SMTP server.");
        Transport.send(reply);
        LogHolder.log(7, LogType.MISC, "MailHandler: createReply: Ban warning was sent.");
    }
}

