/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central.server;

import infoservice.mailsystem.central.server.util.SocketContainer;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractServerImplementation
implements Runnable {
    private SocketContainer m_socketContainer = null;
    private boolean m_alreadyInUse = false;
    private Object m_synchronizer = new Object();

    protected AbstractServerImplementation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setClientConnection(SocketContainer a_socketContainer) {
        Object object = this.m_synchronizer;
        synchronized (object) {
            if (this.m_alreadyInUse) {
                LogHolder.log(2, LogType.NET, "AbstractServerImplementation: setClientConnection: This server implementation is already in use. Cannot switch the client connection.");
            } else {
                this.m_socketContainer = a_socketContainer;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean canHandleRequest = false;
        Object object = this.m_synchronizer;
        synchronized (object) {
            if (this.m_socketContainer == null) {
                LogHolder.log(2, LogType.NET, "AbstractServerImplementation: run: No client connection is specified.");
            } else if (this.m_alreadyInUse) {
                LogHolder.log(2, LogType.NET, "AbstractServerImplementation: run: This server implementation is already in use.");
            } else {
                this.m_alreadyInUse = true;
                canHandleRequest = true;
            }
        }
        if (canHandleRequest) {
            this.handleClientRequest();
        }
    }

    protected final SocketContainer getSocketContainer() {
        return this.m_socketContainer;
    }

    protected abstract void handleClientRequest();
}

