/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixmessage.crypto;

import anon.anonudp.exception.DecryptionFailed;
import anon.anonudp.exception.EncryptionFailed;
import anon.anonudp.mixmessage.crypto.Counter;
import anon.anonudp.mixpacket.DataPacket;
import anon.anonudp.mixpacket.IPacket;
import anon.anonudp.mixpacket.InitResponse;
import anon.client.crypto.MyAEADParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public final class LinkEncryption {
    private static final int HEADER_SIZE = 7;
    public static final int OVERHEAD = 27;
    private static final int IV_LENGTH = 12;
    private final GCMBlockCipher m_cipherEncrypt;
    private final byte[] m_encryptIV;
    private MyAEADParameters m_encryptKeySpec = null;
    private final Counter m_encryptCounter = new Counter();
    private final byte[] m_plainHeader;
    private final GCMBlockCipher m_cipherDecrypt;
    private final byte[] m_decryptIV;
    private MyAEADParameters m_decryptKeySpec = null;
    private final byte[] m_decryptPlainLinkHeader;

    public LinkEncryption(byte[] linkKey) {
        this.m_cipherEncrypt = new GCMBlockCipher(new AESFastEngine());
        this.m_encryptIV = new byte[12];
        this.m_encryptKeySpec = new MyAEADParameters(new KeyParameter(linkKey), 128, this.m_encryptIV, null);
        this.m_cipherEncrypt.init(true, this.m_encryptKeySpec);
        this.m_plainHeader = new byte[7];
        this.m_cipherDecrypt = new GCMBlockCipher(new AESFastEngine());
        this.m_decryptIV = new byte[12];
        this.m_decryptKeySpec = new MyAEADParameters(new KeyParameter(linkKey), 128, this.m_decryptIV, null);
        this.m_cipherDecrypt.init(false, this.m_decryptKeySpec);
        this.m_decryptKeySpec = new MyAEADParameters(null, 128, this.m_decryptIV, null);
        this.m_decryptPlainLinkHeader = new byte[23];
    }

    public int encrypt(IPacket packet, byte[] encryptedBytes) throws EncryptionFailed {
        try {
            byte[] payload = packet.getData();
            this.m_encryptCounter.count();
            this.m_encryptCounter.asIV(this.m_encryptIV);
            this.m_cipherEncrypt.init(true, this.m_encryptKeySpec);
            System.arraycopy(this.m_encryptIV, 0, encryptedBytes, 0, 4);
            int c = packet.getChannelID();
            this.m_plainHeader[0] = (byte)(c >> 8 & 0xFF);
            this.m_plainHeader[1] = (byte)(c & 0xFF);
            byte[] in = packet.getMessageID();
            System.arraycopy(in, 0, this.m_plainHeader, 2, in.length);
            this.m_plainHeader[2 + in.length] = packet.getPacketType();
            int outOffset = this.m_cipherEncrypt.processBytes(this.m_plainHeader, 0, 7, encryptedBytes, 4);
            outOffset += this.m_cipherEncrypt.doFinal(encryptedBytes, outOffset + 4);
            System.arraycopy(payload, 0, encryptedBytes, outOffset + 4, payload.length);
            return payload.length + 27;
        }
        catch (Exception e) {
            throw new EncryptionFailed("Couldn't link-encrypt the mix packet " + this.m_encryptCounter.asInt() + ".", e);
        }
    }

    public IPacket decrypt(byte[] packetBytes) throws DecryptionFailed {
        try {
            System.arraycopy(packetBytes, 0, this.m_decryptIV, 0, 4);
            this.m_cipherDecrypt.init(false, this.m_decryptKeySpec);
            byte[] payload = new byte[packetBytes.length - 27];
            System.arraycopy(packetBytes, 27, payload, 0, payload.length);
            int outOffset = this.m_cipherDecrypt.processBytes(packetBytes, 4, 23, this.m_decryptPlainLinkHeader, 0);
            outOffset += this.m_cipherDecrypt.doFinal(this.m_decryptPlainLinkHeader, outOffset);
            int channelID = (this.m_decryptPlainLinkHeader[0] & 0xFF) << 8;
            channelID |= this.m_decryptPlainLinkHeader[1] & 0xFF;
            byte messageType = this.m_decryptPlainLinkHeader[6];
            IPacket returnPacket = null;
            if (messageType == 1) {
                byte[] messagePrefix = new byte[4];
                System.arraycopy(this.m_decryptPlainLinkHeader, 2, messagePrefix, 0, messagePrefix.length);
                returnPacket = new DataPacket(channelID, messagePrefix, payload);
            } else if (messageType == 3) {
                returnPacket = new InitResponse(channelID, payload);
            }
            return returnPacket;
        }
        catch (Exception e) {
            throw new DecryptionFailed("Couldn't link-decrypt the mix packet ", e);
        }
    }
}

