/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.ByteSignature;
import anon.crypto.IMyPrivateKey;
import anon.crypto.JAPCertificate;
import anon.crypto.MyX509Extensions;
import anon.crypto.PKCS12;
import anon.crypto.RevokedCertificate;
import anon.crypto.X509CertificateIssuer;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509IssuingDistributionPoint;
import anon.util.Base64;
import anon.util.IResourceInstantiator;
import anon.util.IXMLEncodable;
import anon.util.ResourceLoader;
import anon.util.XMLUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.TBSCertList;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CertificateRevocationList
implements IXMLEncodable {
    private static final String BASE64_TAG = "X509 CRL";
    private static final String XML_ELEMENT_NAME = "X509CRL";
    private CertificateList m_crl;
    private Date m_thisUpdate;
    private Date m_nextUpdate;
    private X509DistinguishedName m_issuer;
    private MyX509Extensions m_extensions;

    public CertificateRevocationList(PKCS12 a_issuerCertificate, Vector a_certList, Date a_nextUpdate, MyX509Extensions a_extensions) {
        this(new CRLGenerator(a_issuerCertificate.getSubject().getX500Name(), a_certList, a_nextUpdate, a_extensions).sign(a_issuerCertificate));
    }

    public CertificateRevocationList(CertificateList a_crl) {
        this.m_crl = a_crl;
        this.m_issuer = new X509DistinguishedName(this.m_crl.getIssuer());
        this.m_extensions = new MyX509Extensions(this.m_crl.getTBSCertList().getExtensions());
        this.m_thisUpdate = this.m_crl.getThisUpdate().getDate();
        if (this.m_crl.getNextUpdate() != null) {
            this.m_nextUpdate = this.m_crl.getNextUpdate().getDate();
        }
    }

    public static CertificateRevocationList getInstance(byte[] a_rawCRL) {
        if (a_rawCRL == null || a_rawCRL.length == 0) {
            return null;
        }
        try {
            ASN1Sequence crl = JAPCertificate.toASN1Sequence(a_rawCRL, XML_ELEMENT_NAME);
            return new CertificateRevocationList(CertificateList.getInstance(crl));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CertificateRevocationList getInstance(File a_file) {
        if (a_file != null) {
            try {
                return CertificateRevocationList.getInstance(new FileInputStream(a_file));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CertificateRevocationList getInstance(InputStream a_in) {
        byte[] bytes;
        try {
            bytes = ResourceLoader.getStreamAsBytes(a_in);
        }
        catch (IOException a_e) {
            return null;
        }
        return CertificateRevocationList.getInstance(bytes);
    }

    public static Hashtable getInstance(String a_strResourceSearchPath, boolean a_bRecursive, String a_ignoreCertMark) {
        try {
            return ResourceLoader.loadResources(a_strResourceSearchPath, new CRLInstantiator(a_ignoreCertMark), a_bRecursive);
        }
        catch (Exception a_e) {
            return new Hashtable();
        }
    }

    public X509DistinguishedName getIssuer() {
        return this.m_issuer;
    }

    public boolean isIndirectCRL() {
        X509IssuingDistributionPoint idp = (X509IssuingDistributionPoint)this.m_extensions.getExtension(X509IssuingDistributionPoint.IDENTIFIER);
        if (idp != null) {
            return idp.isIndirectCRL();
        }
        return false;
    }

    public Date getThisUpdate() {
        return this.m_thisUpdate;
    }

    public Date getNextUpdate() {
        return this.m_nextUpdate;
    }

    public MyX509Extensions getExtensions() {
        return this.m_extensions;
    }

    public Vector getRevokedCertificates() {
        Vector<RevokedCertificate> v = new Vector<RevokedCertificate>();
        TBSCertList.CRLEntry[] crlEntries = this.m_crl.getRevokedCertificates();
        for (int i = 0; i < crlEntries.length; ++i) {
            v.addElement(new RevokedCertificate(crlEntries[i]));
        }
        return v;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            new DEROutputStream(bos).writeObject(this.m_crl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public byte[] toByteArray(boolean a_Base64Encoded) {
        if (a_Base64Encoded) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                out.write(Base64.createBeginTag(BASE64_TAG).getBytes());
                out.write(Base64.encode(this.toByteArray(), true).getBytes());
                out.write(Base64.createEndTag(BASE64_TAG).getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return out.toByteArray();
        }
        return this.toByteArray();
    }

    public boolean verifiy(JAPCertificate a_cert) {
        if (a_cert == null) {
            return false;
        }
        try {
            ByteArrayOutputStream bArrOStream = new ByteArrayOutputStream();
            new DEROutputStream(bArrOStream).writeObject(this.m_crl.getTBSCertList());
            return ByteSignature.verify(bArrOStream.toByteArray(), this.m_crl.getSignature().getBytes(), a_cert.getPublicKey());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Element toXmlElement(Document a_doc) {
        Element elemX509Crl = a_doc.createElement(XML_ELEMENT_NAME);
        elemX509Crl.setAttribute("xml:space", "preserve");
        XMLUtil.setValue((Node)elemX509Crl, Base64.encode(this.toByteArray(), true));
        return elemX509Crl;
    }

    private static final class CRLInstantiator
    implements IResourceInstantiator {
        private String m_ignoreCRLMark;

        public CRLInstantiator(String a_strIgnoreCertMark) {
            this.m_ignoreCRLMark = a_strIgnoreCertMark;
        }

        public Object getInstance(File a_file, File directory) throws Exception {
            if (a_file == null || this.isBlocked(a_file.getName())) {
                return null;
            }
            return CertificateRevocationList.getInstance(a_file);
        }

        public Object getInstance(ZipEntry a_entry, ZipFile a_file) throws Exception {
            if (a_file == null || this.isBlocked(a_entry.getName())) {
                return null;
            }
            return CertificateRevocationList.getInstance(a_file.getInputStream(a_entry));
        }

        public Object getInstance(InputStream a_inputStream, String a_resourceName) {
            if (a_resourceName == null || this.isBlocked(a_resourceName)) {
                return null;
            }
            return CertificateRevocationList.getInstance(a_inputStream);
        }

        private boolean isBlocked(String a_resourceName) {
            if (this.m_ignoreCRLMark == null || a_resourceName == null || this.m_ignoreCRLMark.trim().length() == 0) {
                return false;
            }
            if (a_resourceName.endsWith(this.m_ignoreCRLMark)) {
                return true;
            }
            int index = a_resourceName.indexOf(this.m_ignoreCRLMark);
            return index >= 0 && (a_resourceName = a_resourceName.substring(index, a_resourceName.length())).indexOf("/") < 0 && a_resourceName.indexOf(File.separator) < 0;
        }
    }

    private static final class CRLGenerator
    extends V2TBSCertListGenerator {
        public CRLGenerator(X500Name a_issuer, Vector a_certList, Date a_nextUpdate, MyX509Extensions a_extensions) {
            this.setIssuer(a_issuer);
            this.setThisUpdate(new Time(new Date()));
            if (a_nextUpdate != null) {
                this.setNextUpdate(new Time(a_nextUpdate));
            }
            this.setExtensions(a_extensions.getExtensionsAsBCExtensions());
            if (a_certList != null) {
                Enumeration certificates = a_certList.elements();
                while (certificates.hasMoreElements()) {
                    MyX509Extensions entryExtensions = null;
                    JAPCertificate currentCertificate = (JAPCertificate)certificates.nextElement();
                    if (!currentCertificate.getIssuer().equals(a_issuer)) {
                        entryExtensions = new MyX509Extensions(new X509CertificateIssuer(currentCertificate.getIssuer()));
                    }
                    RevokedCertificate revCert = new RevokedCertificate(currentCertificate, new Date(), entryExtensions);
                    this.addCRLEntry(revCert.toASN1Sequence());
                }
            }
        }

        public CertificateList sign(PKCS12 a_privateIssuerCertificate) {
            return this.sign(a_privateIssuerCertificate.getPrivateKey());
        }

        public CertificateList sign(IMyPrivateKey a_privateKey) {
            try {
                this.setSignature(a_privateKey.getSignatureAlgorithm().getIdentifier());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                TBSCertList tbsList = this.generateTBSCertList();
                new DEROutputStream(bOut).writeObject(tbsList);
                byte[] signature = ByteSignature.sign(bOut.toByteArray(), a_privateKey);
                ASN1EncodableVector seqv = new ASN1EncodableVector();
                seqv.add(tbsList);
                seqv.add(a_privateKey.getSignatureAlgorithm().getIdentifier());
                seqv.add(new DERBitString(signature));
                return new CertificateList(new DERSequence(seqv));
            }
            catch (Throwable t) {
                LogHolder.log(2, LogType.CRYPTO, t);
                return null;
            }
        }
    }
}

