/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.io.ByteArrayInputStream;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBankAccount
implements IXMLEncodable {
    private String m_type;
    private String m_details;
    private String m_operatorCert = "none";
    private Document m_docTheBankAccount;
    public static String ms_strElemName = "BankAccount";

    public XMLBankAccount(String type, String details) {
        this.m_type = type;
        this.m_details = details;
        this.m_docTheBankAccount = XMLUtil.createDocument();
        this.m_docTheBankAccount.appendChild(this.internal_toXmlElement(this.m_docTheBankAccount));
    }

    public XMLBankAccount(String type, String details, String operatorCert) {
        this.m_type = type;
        this.m_details = details;
        this.m_operatorCert = operatorCert;
        this.m_docTheBankAccount = XMLUtil.createDocument();
        this.m_docTheBankAccount.appendChild(this.internal_toXmlElement(this.m_docTheBankAccount));
    }

    private Node internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(ms_strElemName);
        elemRoot.setAttribute("version", "1.0");
        Element elem = a_doc.createElement("Type");
        XMLUtil.setValue((Node)elem, this.m_type);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Details");
        XMLUtil.setValue((Node)elem, this.m_details);
        elemRoot.appendChild(elem);
        if (!this.m_operatorCert.equals("none")) {
            elem = a_doc.createElement("OperatorCert");
            XMLUtil.setValue((Node)elem, this.m_operatorCert);
            elemRoot.appendChild(elem);
        }
        return elemRoot;
    }

    public XMLBankAccount(String xml) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheBankAccount = doc;
    }

    public XMLBankAccount(char[] xml) throws Exception {
        this(new String(xml));
    }

    public XMLBankAccount(byte[] xmldata) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(xmldata);
        Document doc = XMLUtil.readXMLDocument(in);
        this.setValues(doc.getDocumentElement());
        this.m_docTheBankAccount = doc;
    }

    public XMLBankAccount(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheBankAccount = XMLUtil.createDocument();
        this.m_docTheBankAccount.appendChild(XMLUtil.importNode(this.m_docTheBankAccount, xml, true));
    }

    public XMLBankAccount(Document xml) throws Exception {
        Element elemRoot = xml.getDocumentElement();
        this.setValues(elemRoot);
        this.m_docTheBankAccount = xml;
    }

    private void setValues(Element xml) throws Exception {
        if (!xml.getTagName().equals("BankAccount")) {
            throw new Exception("XMLBankAccount: cannot parse, wrong xml format!");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(xml, "Type");
        this.m_type = XMLUtil.parseValue((Node)elem, "error");
        if (this.m_type.equals("error")) {
            throw new Exception("XMLBankAccount: cannot parse the account type");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "Details");
        this.m_details = XMLUtil.parseValue((Node)elem, "error");
        if (this.m_details.equals("error")) {
            throw new Exception("XMLBankAccount: cannot parse the account details");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "OperatorCert");
        this.m_operatorCert = XMLUtil.parseValue((Node)elem, "none");
        if (this.m_operatorCert.equals("error")) {
            LogHolder.log(3, LogType.PAY, "XMLBankAccount: no operator cert set");
        }
    }

    public String getType() {
        return this.m_type;
    }

    public String getDetails() {
        return this.m_details;
    }

    public String getOperatorCert() {
        return this.m_operatorCert;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheBankAccount.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }
}

