/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.crypto.MyRandom;
import anon.infoservice.Database;
import anon.infoservice.ServiceOperator;
import anon.pay.PayAccountsFile;
import anon.proxy.AbstractHTTPConnectionListener;
import anon.proxy.AnonProxyRequest;
import anon.proxy.HTTPConnectionEvent;
import anon.proxy.HTTPHeaderParseException;
import anon.proxy.ProxyCallback;
import anon.proxy.ProxyCallbackBuffer;
import anon.proxy.ProxyCallbackNotProcessableException;
import anon.util.JAPMessages;
import anon.util.URLCoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class HTTPProxyCallback
implements ProxyCallback {
    private static final boolean FIRE_EVENT = true;
    private static final MyRandom RANDOM = new MyRandom();
    public static final String MSG_URL_ANONYMITY_TEST = (class$anon$proxy$HTTPProxyCallback == null ? (class$anon$proxy$HTTPProxyCallback = HTTPProxyCallback.class$("anon.proxy.HTTPProxyCallback")) : class$anon$proxy$HTTPProxyCallback).getName() + ".urlAnonymityTest";
    static final int MESSAGE_TYPE_REQUEST = 0;
    static final int MESSAGE_TYPE_RESPONSE = 1;
    static final String CRLF = "\r\n";
    static final String HTTP_HEADER_END = "\r\n\r\n";
    static final byte[] HTTP_HEADER_END_BYTES = new byte[]{13, 10, 13, 10};
    static final String HTTP_HEADER_DELIM = ": ";
    public static final String HTTP_START_LINE_KEY = "start-line";
    public static final String HTTP_VERSION_PREFIX = "HTTP/";
    static final byte[] HTTP_VERSION_PREFIX_BYTES = "HTTP/".getBytes();
    static final String[] HTTP_REQUEST_METHODS = new String[]{"GET", "POST", "CONNECT", "HEAD", "PUT", "OPTIONS", "DELETE", "TRACE"};
    static final byte[][] HTTP_REQUEST_METHODS_BYTES = new byte[HTTP_REQUEST_METHODS.length][];
    static final String MSG_INVALID_LINETERM_REQUEST = "httpFilter.invalidlineterm.request";
    static final String MSG_INVALID_LINETERM_RESPONSE = "httpFilter.invalidlineterm.response";
    public static final String HTTP_CONTENT_LENGTH = "Content-Length";
    public static final String HTTP_CONTENT_ENCODING = "Content-Encoding";
    public static final String HTTP_CONTENT_TYPE = "Content-Type";
    public static final String HTTP_HOST = "Host";
    public static final String HTTP_USER_AGENT = "User-Agent";
    public static final String HTTP_ACCEPT = "Accept";
    public static final String HTTP_LOCATION = "Location";
    public static final String HTTP_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HTTP_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HTTP_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HTTP_KEEP_ALIVE = "Keep-Alive";
    public static final String HTTP_ATTR_KEEP_ALIVE = "keep-alive";
    public static final String HTTP_ATTR_CLOSE = "close";
    public static final String HTTP_PROXY_CONNECTION = "Proxy-Connection";
    public static final String HTTP_CONNECTION = "Connection";
    public static final String HTTP_REFERER = "Referer";
    public static final String HTTP_CACHE_CONTROL = "Cache-Control";
    public static final String HTTP_COOKIE = "Cookie";
    public static final String HTTP_PRAGMA = "Pragma";
    public static final String HTTP_RANGE = "Range";
    public static final String HTTP_IE_UA_CPU = "UA-CPU";
    public static final int REDIRECT_ANONYMITY_TEST = 0;
    public static final int REDIRECT_SQUID_REMINDER = 1;
    private static long ms_lCountHTML;
    private static long ms_lTotalCountHTML;
    private static long ms_lNextRedirect;
    private static int ms_iRedirectProbability;
    private static boolean ms_bCountRedirect;
    private static final Object SYNC_COUNTER;
    private Hashtable m_connectionHTTPHeaders = new Hashtable();
    private Hashtable m_unfinishedRequests = new Hashtable();
    private Hashtable m_unfinishedResponses = new Hashtable();
    private Hashtable m_downstreamBytes = new Hashtable();
    private Hashtable m_upstreamBytes = new Hashtable();
    private Vector m_httpConnectionListeners = new Vector();
    private boolean m_bBlockHTTPListeners = false;
    private static final IHTTPHelper UPSTREAM_HELPER;
    private static final IHTTPHelper DOWNSTREAM_HELPER;
    static /* synthetic */ Class class$anon$proxy$HTTPProxyCallback;
    static /* synthetic */ Class class$anon$infoservice$ServiceOperator;

    public int handleUpstreamChunk(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer) throws ProxyCallbackNotProcessableException {
        return this.handleStreamChunk(anonRequest, buffer, 0, UPSTREAM_HELPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleDownstreamChunk(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer) throws ProxyCallbackNotProcessableException {
        boolean noResponseExpected = false;
        HTTPProxyCallback hTTPProxyCallback = this;
        synchronized (hTTPProxyCallback) {
            HTTPConnectionHeader connHeader = (HTTPConnectionHeader)this.m_connectionHTTPHeaders.get(anonRequest);
            noResponseExpected = connHeader == null ? true : !connHeader.isResponseExpected();
        }
        return noResponseExpected ? 2 : this.handleStreamChunk(anonRequest, buffer, 1, DOWNSTREAM_HELPER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int handleStreamChunk(AnonProxyRequest anonRequest, ProxyCallbackBuffer buffer, int a_messageType, IHTTPHelper a_helper) throws ProxyCallbackNotProcessableException {
        int startOffset = buffer.getModificationStartOffset();
        int endOffset = buffer.getModificationEndOffset();
        int length = endOffset - startOffset + 1;
        byte[] chunk = buffer.getChunk();
        if (anonRequest == null) {
            throw new NullPointerException("AnonProxyRequest must not be null!");
        }
        int headerEndLength = HTTP_HEADER_END.length();
        int headerEndIndex = -1;
        byte[] prefixBytes = null;
        Hashtable unfinishedMessages = a_messageType == 0 ? this.m_unfinishedRequests : this.m_unfinishedResponses;
        String unfinishedHeaderPart = null;
        Hashtable byteCounter = a_messageType == 0 ? this.m_upstreamBytes : this.m_downstreamBytes;
        HTTPProxyCallback hTTPProxyCallback = this;
        synchronized (hTTPProxyCallback) {
            unfinishedHeaderPart = (String)unfinishedMessages.get(anonRequest);
        }
        if (unfinishedHeaderPart != null) {
            prefixBytes = unfinishedHeaderPart.length() > HTTP_HEADER_END_BYTES.length - 1 ? unfinishedHeaderPart.substring(unfinishedHeaderPart.length() - (HTTP_HEADER_END_BYTES.length - 1)).getBytes() : unfinishedHeaderPart.getBytes();
        }
        int endLen = (headerEndIndex = HTTPProxyCallback.indexOfHTTPHeaderEnd(prefixBytes, chunk, startOffset, endOffset)) == -1 ? length : headerEndIndex - startOffset;
        int contentBytes = length;
        String chunkData = null;
        if (unfinishedHeaderPart != null || this.hasAlignedHTTPStartLine(chunk, startOffset, endLen, a_messageType)) {
            contentBytes = length - endLen;
            chunkData = (unfinishedHeaderPart == null ? "" : unfinishedHeaderPart) + new String(chunk, startOffset, endLen);
            boolean finished = false;
            byte[] newHeaders = null;
            HTTPConnectionHeader connHeader = null;
            boolean prepareNewChunk = false;
            try {
                finished = this.extractHeaderParts(anonRequest, chunkData, a_messageType);
                if (!finished) {
                    return 1;
                }
                HTTPProxyCallback hTTPProxyCallback2 = this;
                synchronized (hTTPProxyCallback2) {
                    connHeader = (HTTPConnectionHeader)this.m_connectionHTTPHeaders.get(anonRequest);
                    prepareNewChunk = connHeader != null && connHeader.getRequestLine() != null;
                }
            }
            catch (DownstreamUnhandledException e) {
                newHeaders = chunkData.getBytes();
                prepareNewChunk = true;
                LogHolder.log(4, LogType.NET, "Skipped parsing of invalid response headers:\n" + chunkData);
            }
            if (prepareNewChunk) {
                if (newHeaders == null) {
                    newHeaders = a_helper.dumpHeader(this, connHeader, anonRequest);
                }
                this.countContentBytes(anonRequest, contentBytes, byteCounter, true);
                int contentDataStart = newHeaders.length + startOffset;
                int trailingDataStart = contentDataStart + contentBytes;
                byte[] newChunk = new byte[trailingDataStart + buffer.getTrailingDataLength()];
                buffer.copyLeadingData(newChunk);
                System.arraycopy(newHeaders, 0, newChunk, startOffset, newHeaders.length);
                System.arraycopy(chunk, endOffset + 1 - contentBytes, newChunk, contentDataStart, contentBytes);
                buffer.copyTrailingData(newChunk, trailingDataStart);
                buffer.setChunk(newChunk);
                buffer.setModificationStartOffset(contentDataStart);
                buffer.setModificationEndOffset(trailingDataStart - 1);
                return 2;
            }
        }
        this.countContentBytes(anonRequest, contentBytes, byteCounter, true);
        return 2;
    }

    private synchronized long countContentBytes(AnonProxyRequest anonRequest, int contentBytes, Hashtable contentBytesCount, boolean fire) {
        long dsCurrentValue = 0L;
        Long dsCurrentBytes = (Long)contentBytesCount.remove(anonRequest);
        if (dsCurrentBytes != null) {
            dsCurrentValue = dsCurrentBytes;
        }
        contentBytesCount.put(anonRequest, new Long(dsCurrentValue += (long)contentBytes));
        if (fire) {
            HTTPConnectionEvent event = new HTTPConnectionEvent();
            event.setAnonRequest(anonRequest);
            event.setConnectionHeader((HTTPConnectionHeader)this.m_connectionHTTPHeaders.get(anonRequest));
            if (contentBytesCount == this.m_downstreamBytes) {
                event.setUpStreamContentBytes(this.getUpStreamContentBytes(anonRequest));
                event.setDownStreamContentBytes(dsCurrentValue);
                this.fireDownstreamContentBytesReceived(event);
            } else if (contentBytesCount == this.m_upstreamBytes) {
                event.setDownStreamContentBytes(this.getDownStreamContentBytes(anonRequest));
                event.setUpStreamContentBytes(dsCurrentValue);
                this.fireUpstreamContentBytesReceived(event);
            }
        }
        return dsCurrentValue;
    }

    public synchronized long getUpStreamContentBytes(AnonProxyRequest anonRequest) {
        return this.getContentBytes(anonRequest, this.m_upstreamBytes);
    }

    public synchronized long getDownStreamContentBytes(AnonProxyRequest anonRequest) {
        return this.getContentBytes(anonRequest, this.m_downstreamBytes);
    }

    private long getContentBytes(AnonProxyRequest anonRequest, Hashtable contentByteCount) {
        if (contentByteCount == null) {
            throw new NullPointerException("Bug: No count table specified for getContentBytes");
        }
        Long contentBytes = (Long)contentByteCount.get(anonRequest);
        return contentBytes == null ? 0L : contentBytes;
    }

    private synchronized HTTPConnectionEvent getEvent(AnonProxyRequest anonRequest) {
        long upStreamBytes = this.getUpStreamContentBytes(anonRequest);
        long downStreamBytes = this.getDownStreamContentBytes(anonRequest);
        HTTPConnectionHeader connHeader = (HTTPConnectionHeader)this.m_connectionHTTPHeaders.get(anonRequest);
        return new HTTPConnectionEvent(connHeader, upStreamBytes, downStreamBytes, anonRequest);
    }

    private synchronized boolean extractHeaderParts(AnonProxyRequest anonRequest, String chunkData, int messageType) throws ProxyCallbackNotProcessableException, DownstreamUnhandledException {
        String headerFragment;
        if (anonRequest == null) {
            throw new NullPointerException("AnonProxyRequest must not be null!");
        }
        HTTPConnectionHeader connHeader = null;
        connHeader = (HTTPConnectionHeader)this.m_connectionHTTPHeaders.get(anonRequest);
        if (connHeader != null) {
            if (messageType == 0 && connHeader.isRequestFinished()) {
                connHeader.clearRequest();
                this.m_upstreamBytes.remove(anonRequest);
            } else if (messageType == 1 && connHeader.isResponseFinished()) {
                connHeader.clearResponse();
                this.m_downstreamBytes.remove(anonRequest);
            }
        }
        if (connHeader == null) {
            connHeader = new HTTPConnectionHeader();
            this.m_connectionHTTPHeaders.put(anonRequest, connHeader);
        }
        Hashtable unfinishedMessages = messageType == 0 ? this.m_unfinishedRequests : this.m_unfinishedResponses;
        int off_headers_end = chunkData.indexOf(HTTP_HEADER_END);
        String string = headerFragment = off_headers_end == -1 ? chunkData : chunkData.substring(0, off_headers_end);
        if (!HTTPProxyCallback.checkValidity(headerFragment)) {
            String errorMsgKey = null;
            if (messageType == 0) {
                connHeader.setRequestFinished(true);
                errorMsgKey = MSG_INVALID_LINETERM_REQUEST;
            } else if (messageType == 1) {
                connHeader.setResponseFinished(true);
                errorMsgKey = MSG_INVALID_LINETERM_RESPONSE;
                throw new DownstreamUnhandledException();
            }
            unfinishedMessages.remove(anonRequest);
            LogHolder.log(3, LogType.FILTER, "Error while parsing header: " + headerFragment);
            throw new HTTPHeaderParseException(400, messageType, JAPMessages.getString(errorMsgKey));
        }
        if (off_headers_end != -1) {
            this.parseHTTPHeader(headerFragment, connHeader, messageType);
            if (messageType == 0) {
                connHeader.setRequestFinished(true);
                connHeader.setResponseExpected(true);
            } else if (messageType == 1) {
                connHeader.setResponseFinished(true);
                connHeader.setResponseExpected(false);
            }
            unfinishedMessages.remove(anonRequest);
            return true;
        }
        unfinishedMessages.put(anonRequest, chunkData);
        return false;
    }

    public static boolean isJonDosDomain(HTTPConnectionHeader a_connectionHeader) {
        if (a_connectionHeader == null) {
            return false;
        }
        return HTTPProxyCallback.isJonDosDomain(a_connectionHeader.parseDomain(true));
    }

    public static boolean isAnonymityTestDomain(HTTPConnectionHeader a_connectionHeader) {
        if (a_connectionHeader == null) {
            return false;
        }
        return HTTPProxyCallback.isAnonymityTestDomain(a_connectionHeader.parseDomain(false));
    }

    protected void resetRedirect(int a_probability, boolean a_bCount) {
        ms_iRedirectProbability = a_probability;
        if (ms_iRedirectProbability >= 0) {
            if (ms_lNextRedirect < 0L) {
                ms_lNextRedirect = 20L;
                if (!ms_bCountRedirect) {
                    ms_bCountRedirect = true;
                    ms_lCountHTML = 0L;
                }
            }
        } else {
            ms_bCountRedirect = a_bCount;
            ms_lNextRedirect = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean redirect(HTTPConnectionHeader a_connectionHeader, int a_redirectTarget) {
        if (a_redirectTarget == 1 && (!ms_bCountRedirect || HTTPProxyCallback.isJonDosDomain(a_connectionHeader))) {
            return false;
        }
        if (a_redirectTarget == 0 && HTTPProxyCallback.isAnonymityTestDomain(a_connectionHeader)) {
            return false;
        }
        String[] strContentTypes = a_connectionHeader.getResponseHeader(HTTP_CONTENT_TYPE);
        boolean bRedirect = false;
        if (strContentTypes != null && strContentTypes.length > 0 && a_connectionHeader.parseStatus() == 200 && a_connectionHeader.getRequestLine().startsWith("GET")) {
            for (int i = 0; i < strContentTypes.length; ++i) {
                if (strContentTypes[i].toLowerCase().indexOf("text/html") < 0) continue;
                bRedirect = true;
                if (a_redirectTarget != 1 || ms_lTotalCountHTML >= 100L) break;
                ++ms_lTotalCountHTML;
                break;
            }
        }
        if (bRedirect && a_redirectTarget == 1) {
            Object i = SYNC_COUNTER;
            synchronized (i) {
                if (ms_lNextRedirect < 0L || ms_lNextRedirect > ms_lCountHTML) {
                    bRedirect = false;
                    ++ms_lCountHTML;
                } else if (ms_iRedirectProbability < 0) {
                    bRedirect = false;
                } else {
                    if (ms_lNextRedirect > 0L) {
                        --ms_lNextRedirect;
                    }
                    ms_lCountHTML = 0L;
                }
                if (ms_iRedirectProbability > 0 && ms_lTotalCountHTML * 100L >= (long)(10000 / ms_iRedirectProbability) && ms_iRedirectProbability > RANDOM.nextInt(100)) {
                    bRedirect = true;
                }
            }
        }
        if (bRedirect) {
            String replaceURL = a_redirectTarget == 1 ? "http://premium-" + JAPMessages.getLocale().getLanguage() : JAPMessages.getString(MSG_URL_ANONYMITY_TEST);
            a_connectionHeader.removeResponseHeaders();
            a_connectionHeader.replaceResponseHeader(HTTP_START_LINE_KEY, "HTTP/1.0 302 Moved Temporarily");
            a_connectionHeader.replaceResponseHeader(HTTP_LOCATION, replaceURL);
            a_connectionHeader.replaceResponseHeader(HTTP_CONTENT_TYPE, "text/html");
            a_connectionHeader.replaceResponseHeader(HTTP_CONNECTION, HTTP_ATTR_CLOSE);
        }
        return bRedirect;
    }

    private static boolean isJonDosDomain(String a_domain) {
        if (a_domain == null) {
            return false;
        }
        return a_domain.equals("anonymous-proxy-servers.net") || a_domain.equals("anonym-surfen.de") || a_domain.equals("anonym-surfen.de") || a_domain.equals("jondopay.de") || HTTPProxyCallback.isAnonymityTestDomain(a_domain) || HTTPProxyCallback.isOperatorDomain(a_domain);
    }

    private static boolean isOperatorDomain(String a_domain) {
        Enumeration enumOperators = Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = HTTPProxyCallback.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntrySnapshotAsEnumeration();
        while (enumOperators.hasMoreElements()) {
            ServiceOperator operator = (ServiceOperator)enumOperators.nextElement();
            if (operator.getUrl() == null || !a_domain.equals(HTTPProxyCallback.parseDomain(operator.getUrl(), true))) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnonymityTestDomain(String a_domain) {
        if (a_domain == null) {
            return false;
        }
        return a_domain.equals("ip-check.info") || a_domain.equals("ipcheck.info") || a_domain.equals("ip-check.org") || a_domain.equals("what-is-my-ip-address.anonymous-proxy-servers.net") || a_domain.equals("what-is-my-ip-address.anonymous-proxy-servers.eu");
    }

    public static boolean checkValidity(String headerData) {
        boolean indexExceeds;
        int currentCRIndex = -1;
        int currentLFIndex = -1;
        boolean onlyCR = false;
        boolean onlyLF = false;
        boolean endsWithCR = false;
        boolean noMoreLineTerminations = false;
        boolean bl = indexExceeds = Math.max(currentCRIndex + 1, currentLFIndex + 1) >= headerData.length();
        while (!indexExceeds) {
            currentCRIndex = headerData.indexOf(13, currentCRIndex + 1);
            currentLFIndex = headerData.indexOf(10, currentLFIndex + 1);
            boolean bl2 = noMoreLineTerminations = currentCRIndex == -1 && currentLFIndex == -1;
            if (noMoreLineTerminations) break;
            boolean bl3 = onlyLF = currentLFIndex != -1 && (currentCRIndex == -1 || currentCRIndex != currentLFIndex - 1);
            if (onlyLF) break;
            onlyCR = currentCRIndex != -1 && (currentLFIndex == -1 || currentCRIndex != currentLFIndex - 1);
            boolean bl4 = endsWithCR = currentCRIndex == headerData.length() - 1;
            if (endsWithCR) break;
            indexExceeds = Math.max(currentCRIndex + 1, currentLFIndex + 1) >= headerData.length();
        }
        return !onlyLF && (!onlyCR || endsWithCR);
    }

    private boolean hasAlignedHTTPStartLine(String chunkData, int messageType) {
        return messageType == 0 ? this.isRequest(chunkData) : this.isResponse(chunkData);
    }

    private boolean hasAlignedHTTPStartLine(byte[] chunk, int off, int len, int messageType) {
        return messageType == 0 ? this.isRequest(chunk, off, len) : this.isResponse(chunk, off, len);
    }

    private boolean isRequest(String chunkData) {
        for (int i = 0; i < HTTP_REQUEST_METHODS.length; ++i) {
            if (!chunkData.startsWith(HTTP_REQUEST_METHODS[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isRequest(byte[] chunk, int off, int len) {
        boolean match = true;
        for (int i = 0; i < HTTP_REQUEST_METHODS_BYTES.length; ++i) {
            int compLen = Math.min(len, HTTP_REQUEST_METHODS_BYTES[i].length);
            for (int j = off; j < compLen; ++j) {
                if (chunk[j] == HTTP_REQUEST_METHODS_BYTES[i][j]) continue;
                match = false;
                break;
            }
            if (match) {
                return true;
            }
            match = true;
        }
        return false;
    }

    private boolean isResponse(String chunkData) {
        return chunkData.startsWith(HTTP_VERSION_PREFIX);
    }

    private boolean isResponse(byte[] chunk, int off, int len) {
        int compLen = Math.min(len, HTTP_VERSION_PREFIX_BYTES.length);
        for (int i = off; i < compLen; ++i) {
            if (chunk[i] == HTTP_VERSION_PREFIX_BYTES[i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOfHTTPHeaderEnd(byte[] chunk, int startIndex, int endIndex) {
        boolean match = false;
        for (int i = startIndex; i <= endIndex - (HTTP_HEADER_END_BYTES.length - 1); ++i) {
            match = true;
            for (int j = 0; j < HTTP_HEADER_END_BYTES.length; ++j) {
                if (chunk[i + j] == HTTP_HEADER_END_BYTES[j]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return i + HTTP_HEADER_END_BYTES.length;
        }
        return -1;
    }

    public static int indexOfHTTPHeaderEnd(byte[] prefix, byte[] chunk, int chunkStartIndex, int chunkEndIndex) {
        if (prefix != null) {
            int startIndex;
            boolean match = false;
            int prefixLength = prefix.length;
            int n = startIndex = prefixLength >= HTTP_HEADER_END_BYTES.length - 1 ? prefixLength - (HTTP_HEADER_END_BYTES.length - 1) : 0;
            if (chunkEndIndex + 1 + prefixLength < HTTP_HEADER_END_BYTES.length) {
                return -1;
            }
            for (int i = startIndex; i < prefixLength; ++i) {
                int k;
                int chunkCheckLength = HTTP_HEADER_END_BYTES.length - (prefixLength - i);
                if (chunkCheckLength > chunkEndIndex - chunkStartIndex + 1) {
                    return -1;
                }
                match = true;
                int j = 0;
                while (i + j < prefixLength) {
                    if (prefix[i + j] != HTTP_HEADER_END_BYTES[j]) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (!match) continue;
                for (k = chunkStartIndex; k < chunkCheckLength || j < HTTP_HEADER_END_BYTES.length; ++k) {
                    if (chunk[k] == HTTP_HEADER_END_BYTES[j++]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return k;
            }
        }
        return HTTPProxyCallback.indexOfHTTPHeaderEnd(chunk, chunkStartIndex, chunkEndIndex);
    }

    private synchronized void parseHTTPHeader(String headerData, HTTPConnectionHeader connHeader, int headerType) {
        StringTokenizer lineTokenizer = new StringTokenizer(headerData, CRLF);
        if (lineTokenizer.countTokens() == 0) {
            return;
        }
        String header = null;
        String key = null;
        String values = null;
        if (headerType == 0) {
            connHeader.setRequestHeader(HTTP_START_LINE_KEY, lineTokenizer.nextToken());
        } else if (headerType == 1) {
            connHeader.setResponseHeader(HTTP_START_LINE_KEY, lineTokenizer.nextToken());
        }
        while (lineTokenizer.hasMoreTokens()) {
            header = lineTokenizer.nextToken();
            int delim = header.indexOf(HTTP_HEADER_DELIM);
            if (delim == -1) {
                delim = header.indexOf("\n\n");
            }
            if (delim == -1) continue;
            key = header.substring(0, delim).trim();
            if (delim + 1 < header.length()) {
                values = header.substring(delim + 1).trim();
            }
            if (key == null || values == null) continue;
            if (headerType == 0) {
                connHeader.setRequestHeader(key, values);
                continue;
            }
            if (headerType != 1) continue;
            connHeader.setResponseHeader(key, values);
        }
    }

    public synchronized void addHTTPConnectionListener(AbstractHTTPConnectionListener listener) {
        if (!this.m_httpConnectionListeners.contains(listener)) {
            int i;
            for (i = 0; i < this.m_httpConnectionListeners.size() && ((AbstractHTTPConnectionListener)this.m_httpConnectionListeners.elementAt(i)).getPriority() < listener.getPriority(); ++i) {
            }
            this.m_httpConnectionListeners.insertElementAt(listener, i);
        }
    }

    public synchronized void removeHTTPConnectionListener(AbstractHTTPConnectionListener listener) {
        this.m_httpConnectionListeners.removeElement(listener);
    }

    public synchronized void removeAllHTTPConnectionListeners() {
        this.m_httpConnectionListeners.removeAllElements();
    }

    public synchronized void fireRequestHeadersReceived(HTTPConnectionEvent event) {
        Enumeration enumeration = this.m_httpConnectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            AbstractHTTPConnectionListener listener = (AbstractHTTPConnectionListener)enumeration.nextElement();
            if (listener == null || this.m_bBlockHTTPListeners && listener.isBlockable()) continue;
            listener.requestHeadersReceived(event);
        }
        HTTPConnectionHeader connectionHeader = event.getConnectionHeader();
        if (connectionHeader != null) {
            String strURL;
            event.getAnonRequest().setHttpParsed(connectionHeader.parseDomain(false));
            if (ms_lNextRedirect >= 0L && (strURL = connectionHeader.parseURL()) != null && strURL.startsWith("http://premium-") && strURL.indexOf(".") < 0) {
                if (PayAccountsFile.getInstance().isNewUser()) {
                    connectionHeader.setRequestHeader("X-JonDonym-Premium", "false");
                } else {
                    connectionHeader.setRequestHeader("X-JonDonym-Premium", "true");
                }
                try {
                    if (ms_lNextRedirect == 0L) {
                        connectionHeader.replaceRequestHeader("X-JonDonym-Redirect", "permanent");
                    } else {
                        connectionHeader.replaceRequestHeader("X-JonDonym-Redirect", URLCoder.encode(connectionHeader.parseURL()));
                    }
                }
                catch (Exception a_e) {
                    LogHolder.log(3, LogType.NET, a_e);
                }
            }
        }
    }

    public synchronized void fireResponseHeadersReceived(HTTPConnectionEvent event) {
        if (event != null) {
            HTTPProxyCallback.redirect(event.getConnectionHeader(), 1);
        }
        Enumeration enumeration = this.m_httpConnectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            AbstractHTTPConnectionListener listener = (AbstractHTTPConnectionListener)enumeration.nextElement();
            if (listener == null || this.m_bBlockHTTPListeners && listener.isBlockable()) continue;
            listener.responseHeadersReceived(event);
        }
    }

    protected void blockHTTPListeners(boolean a_bBlock) {
        this.m_bBlockHTTPListeners = a_bBlock;
    }

    public synchronized void fireDownstreamContentBytesReceived(HTTPConnectionEvent event) {
        Enumeration enumeration = this.m_httpConnectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            AbstractHTTPConnectionListener listener = (AbstractHTTPConnectionListener)enumeration.nextElement();
            if (listener == null || this.m_bBlockHTTPListeners && listener.isBlockable()) continue;
            listener.downstreamContentBytesReceived(event);
        }
    }

    public synchronized void fireUpstreamContentBytesReceived(HTTPConnectionEvent event) {
        Enumeration enumeration = this.m_httpConnectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            AbstractHTTPConnectionListener listener = (AbstractHTTPConnectionListener)enumeration.nextElement();
            if (listener == null || this.m_bBlockHTTPListeners && listener.isBlockable()) continue;
            listener.upstreamContentBytesReceived(event);
        }
    }

    public synchronized void closeRequest(AnonProxyRequest anonRequest) {
        HTTPConnectionHeader connHeader = (HTTPConnectionHeader)this.m_connectionHTTPHeaders.get(anonRequest);
        if (connHeader != null) {
            connHeader.clearRequest();
            connHeader.clearResponse();
            this.m_upstreamBytes.remove(anonRequest);
            this.m_downstreamBytes.remove(anonRequest);
            this.m_connectionHTTPHeaders.remove(anonRequest);
        }
    }

    public static String parseDomain(String a_URL, boolean a_bRemoveSubdomain) {
        String domain = null;
        if (a_URL != null) {
            int slashix = a_URL.indexOf("://");
            domain = slashix >= 0 ? a_URL.substring(slashix + 3, a_URL.length()) : a_URL;
            slashix = domain.indexOf(" ");
            if (slashix >= 0) {
                domain = domain.substring(0, slashix);
            }
            if (domain.endsWith("/")) {
                domain = domain.substring(0, domain.length() - 1);
            }
            if ((slashix = domain.lastIndexOf(":")) >= 0 && (domain.length() <= slashix + 1 || domain.charAt(slashix + 1) != '/')) {
                domain = domain.substring(0, slashix);
            }
            if ((slashix = domain.indexOf("/")) >= 0) {
                domain = domain.substring(0, slashix);
            }
            while (a_bRemoveSubdomain && (slashix = domain.indexOf(".")) >= 0 && slashix < domain.lastIndexOf(".")) {
                domain = domain.substring(slashix + 1, domain.length());
            }
        }
        if (domain != null && domain.trim().length() == 0) {
            domain = null;
        }
        return domain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < HTTP_REQUEST_METHODS.length; ++i) {
            byte[] currentMethodBytes = HTTP_REQUEST_METHODS[i].getBytes();
            HTTPProxyCallback.HTTP_REQUEST_METHODS_BYTES[i] = currentMethodBytes;
        }
        ms_lCountHTML = 0L;
        ms_lTotalCountHTML = 0L;
        ms_lNextRedirect = -1L;
        ms_iRedirectProbability = -1;
        ms_bCountRedirect = false;
        SYNC_COUNTER = new Object();
        UPSTREAM_HELPER = new IHTTPHelper(){

            public byte[] dumpHeader(HTTPProxyCallback a_callback, HTTPConnectionHeader a_header, AnonProxyRequest anonRequest) {
                a_callback.fireRequestHeadersReceived(a_callback.getEvent(anonRequest));
                return a_header.dumpRequestHeaders();
            }
        };
        DOWNSTREAM_HELPER = new IHTTPHelper(){

            public byte[] dumpHeader(HTTPProxyCallback a_callback, HTTPConnectionHeader a_header, AnonProxyRequest anonRequest) {
                a_callback.fireResponseHeadersReceived(a_callback.getEvent(anonRequest));
                return a_header.dumpResponseHeaders();
            }
        };
    }

    public class DownstreamUnhandledException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public static class HTTPConnectionHeader {
        private Hashtable reqHeaders = new Hashtable();
        private Hashtable resHeaders = new Hashtable();
        private Vector reqHeaderOrder = new Vector();
        private Vector resHeaderOrder = new Vector();
        private boolean requestFinished = false;
        private boolean responseFinished = false;
        private boolean responseExpected = false;

        private synchronized boolean isResponseExpected() {
            return this.responseExpected;
        }

        private synchronized void setResponseExpected(boolean responseExpected) {
            this.responseExpected = responseExpected;
        }

        public Hashtable getRequestHeaders() {
            return (Hashtable)this.reqHeaders.clone();
        }

        public Hashtable getResponseHeaders() {
            return (Hashtable)this.resHeaders.clone();
        }

        public synchronized boolean isResponseFinished() {
            return this.responseFinished;
        }

        private synchronized void setResponseFinished(boolean responseFinished) {
            this.responseFinished = responseFinished;
        }

        private synchronized boolean isRequestFinished() {
            return this.requestFinished;
        }

        public synchronized void setRequestFinished(boolean finished) {
            this.requestFinished = finished;
        }

        public synchronized void setRequestHeader(String header, String value) {
            this.setHeader(this.reqHeaders, this.reqHeaderOrder, header, value);
        }

        public synchronized void setResponseHeader(String header, String value) {
            this.setHeader(this.resHeaders, this.resHeaderOrder, header, value);
        }

        public synchronized void resetRequestHeader(String header) {
            this.resetHeader(this.reqHeaders, this.reqHeaderOrder, header);
        }

        public synchronized void resetResponseHeader(String header) {
            this.resetHeader(this.resHeaders, this.resHeaderOrder, header);
        }

        public synchronized void replaceRequestHeader(String header, String value) {
            this.replaceHeader(this.reqHeaders, this.reqHeaderOrder, header, value);
        }

        public synchronized void replaceResponseHeader(String header, String value) {
            this.replaceHeader(this.resHeaders, this.resHeaderOrder, header, value);
        }

        public synchronized void removeRequestHeaders() {
            this.reqHeaders.clear();
            this.reqHeaderOrder.removeAllElements();
        }

        public synchronized void removeResponseHeaders() {
            this.resHeaders.clear();
            this.resHeaderOrder.removeAllElements();
        }

        public int parseStatus() {
            String strRequest = this.getResponseLine();
            StringTokenizer tokenizer = new StringTokenizer(strRequest);
            tokenizer.nextToken();
            if (strRequest == null) {
                return 500;
            }
            if (!strRequest.startsWith(HTTPProxyCallback.HTTP_VERSION_PREFIX)) {
                return 500;
            }
            if (!tokenizer.hasMoreTokens()) {
                return 500;
            }
            try {
                return Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException a_e) {
                LogHolder.log(3, LogType.NET, a_e);
                return 500;
            }
        }

        public String parseDomain(boolean a_bRemoveSubdomain) {
            return HTTPProxyCallback.parseDomain(this.parseURL(), a_bRemoveSubdomain);
        }

        public String parseURL() {
            String domain = this.getRequestLine();
            if (domain != null) {
                int afterMethod = domain.indexOf(" ");
                domain = afterMethod != -1 ? ((afterMethod = (domain = domain.substring(afterMethod + 1)).indexOf(" ")) != -1 ? domain.substring(0, afterMethod) : null) : null;
            }
            return domain;
        }

        public synchronized String getRequestLine() {
            return this.getStartLine(this.reqHeaders);
        }

        public synchronized String getResponseLine() {
            return this.getStartLine(this.resHeaders);
        }

        public synchronized void replaceResponseLine(String a_newResponseLine) {
            Vector<String> responseLine = new Vector<String>();
            responseLine.addElement(a_newResponseLine);
            this.resHeaders.put(HTTPProxyCallback.HTTP_START_LINE_KEY.toLowerCase(), responseLine);
        }

        public synchronized int countRequestHeaders() {
            return this.reqHeaders.size();
        }

        public synchronized int countResponseHeaders() {
            return this.resHeaders.size();
        }

        public synchronized String[] getRequestHeader(String header) {
            return this.getHeader(this.reqHeaders, header);
        }

        public synchronized String[] getResponseHeader(String header) {
            return this.getHeader(this.resHeaders, header);
        }

        public synchronized String[] removeRequestHeader(String header) {
            return this.removeHeader(this.reqHeaders, this.reqHeaderOrder, header);
        }

        public synchronized String[] removeResponseHeader(String header) {
            return this.removeHeader(this.resHeaders, this.resHeaderOrder, header);
        }

        protected synchronized void clearRequest() {
            this.clearHeader(this.reqHeaders, this.reqHeaderOrder);
        }

        protected synchronized void clearResponse() {
            this.clearHeader(this.resHeaders, this.resHeaderOrder);
        }

        private void setHeader(Hashtable headerMap, Vector headerOrder, String header, String value) {
            Vector<String> valueContainer = (Vector<String>)headerMap.get(header.toLowerCase());
            if (valueContainer == null) {
                boolean addToOrder = true;
                Enumeration enumeration = headerOrder.elements();
                while (enumeration.hasMoreElements()) {
                    String aktheader = (String)enumeration.nextElement();
                    if (!aktheader.equalsIgnoreCase(header)) continue;
                    addToOrder = false;
                }
                if (addToOrder) {
                    headerOrder.addElement(header);
                }
                valueContainer = new Vector<String>();
            }
            valueContainer.addElement(value);
            headerMap.put(header.toLowerCase(), valueContainer);
        }

        private void resetHeader(Hashtable headerMap, Vector headerOrder, String header) {
            String[] strHeaderValue = this.getHeader(headerMap, header);
            if (strHeaderValue != null && strHeaderValue.length > 0) {
                this.replaceRequestHeader(header, strHeaderValue[0]);
            }
        }

        private void replaceHeader(Hashtable headerMap, Vector headerOrder, String header, String value) {
            this.removeHeader(headerMap, headerOrder, header);
            this.setHeader(headerMap, headerOrder, header, value);
        }

        private String[] getHeader(Hashtable headerMap, String header) {
            Vector valueContainer = (Vector)headerMap.get(header.toLowerCase());
            return this.valuesToArray(valueContainer);
        }

        private String[] removeHeader(Hashtable headerMap, Vector headerOrder, String header) {
            Enumeration enumeration = headerOrder.elements();
            while (enumeration.hasMoreElements()) {
                String aktheader = (String)enumeration.nextElement();
                if (!aktheader.equalsIgnoreCase(header)) continue;
                headerOrder.removeElement(aktheader);
            }
            Vector valueContainer = (Vector)headerMap.remove(header.toLowerCase());
            return this.valuesToArray(valueContainer);
        }

        private void clearHeader(Hashtable headerMap, Vector headerOrder) {
            headerMap.clear();
            headerOrder.removeAllElements();
        }

        private String getStartLine(Hashtable headerMap) {
            Vector valueContainer = (Vector)headerMap.get(HTTPProxyCallback.HTTP_START_LINE_KEY.toLowerCase());
            if (valueContainer == null || valueContainer.size() == 0) {
                LogHolder.log(3, LogType.FILTER, "Invalid request because it contains no startline");
                return null;
            }
            if (valueContainer.size() > 1) {
                String errOutput = "";
                for (int i = 0; i < valueContainer.size(); ++i) {
                    errOutput = errOutput + valueContainer.elementAt(i) + "\n";
                }
                LogHolder.log(3, LogType.FILTER, "This HTTP message seems to be invalid, because it has multiple start lines:\n" + errOutput);
            }
            return (String)valueContainer.elementAt(0);
        }

        private String[] valuesToArray(Vector valueContainer) {
            if (valueContainer == null) {
                return null;
            }
            int valueCount = valueContainer.size();
            if (valueCount == 0) {
                return null;
            }
            String[] values = new String[valueCount];
            Enumeration enumeration = valueContainer.elements();
            int i = 0;
            while (enumeration.hasMoreElements()) {
                values[i] = (String)enumeration.nextElement();
                ++i;
            }
            return values;
        }

        private byte[] dumpRequestHeaders() {
            return this.dumpHeaders(this.reqHeaders, this.reqHeaderOrder);
        }

        private byte[] dumpResponseHeaders() {
            return this.dumpHeaders(this.resHeaders, this.resHeaderOrder);
        }

        private byte[] dumpHeaders(Hashtable headerMap, Vector headerOrder) {
            String allHeaders = "";
            String header = null;
            Enumeration enumeration = headerOrder.elements();
            while (enumeration.hasMoreElements()) {
                header = (String)enumeration.nextElement();
                if (header.equalsIgnoreCase(HTTPProxyCallback.HTTP_START_LINE_KEY)) {
                    if (!allHeaders.equals("")) {
                        LogHolder.log(3, LogType.FILTER, "HTTP startline set after Message-Header. This is a Bug. please report this.");
                        throw new IllegalStateException("HTTP startline set after Message-Header. This is a Bug. please report this.");
                    }
                    allHeaders = allHeaders + this.getStartLine(headerMap) + HTTPProxyCallback.CRLF;
                    continue;
                }
                String[] values = this.getHeader(headerMap, header);
                if (values == null) continue;
                for (int i = 0; i < values.length; ++i) {
                    allHeaders = allHeaders + header + HTTPProxyCallback.HTTP_HEADER_DELIM + values[i] + HTTPProxyCallback.CRLF;
                }
            }
            allHeaders = allHeaders + HTTPProxyCallback.CRLF;
            if (LogHolder.isLogged(6, LogType.FILTER)) {
                LogHolder.log(6, LogType.FILTER, Thread.currentThread().getName() + ": header dump:" + System.getProperty("line.separator") + allHeaders);
            }
            return allHeaders.getBytes();
        }
    }

    private static interface IHTTPHelper {
        public byte[] dumpHeader(HTTPProxyCallback var1, HTTPConnectionHeader var2, AnonProxyRequest var3);
    }
}

