/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import java.io.ByteArrayOutputStream;

public class ProxyCallbackBuffer {
    private byte[] chunk = null;
    private int modificationStartOffset = 0;
    private int modificationEndOffset = 0;
    private int payloadLength = 0;
    private int status = 2;

    public ProxyCallbackBuffer() {
        this(new byte[1000]);
    }

    public ProxyCallbackBuffer(byte[] chunk) {
        this(chunk, 0, chunk.length - 1);
    }

    public ProxyCallbackBuffer(byte[] chunk, int modifcationStartOffset, int payloadLength) {
        this.setChunk(chunk);
        this.setModificationStartOffset(modifcationStartOffset);
        this.setPayloadLength(payloadLength);
        this.setModificationEndOffset(payloadLength - 1);
        this.status = 2;
    }

    public ProxyCallbackBuffer(byte[] chunk, int modifcationStartOffset, int modifcationEndOffset, int payloadLength) {
        this.setChunk(chunk);
        this.setModificationStartOffset(modifcationStartOffset);
        this.setModificationEndOffset(modifcationEndOffset);
        this.status = 2;
    }

    public byte[] getChunk() {
        return this.chunk;
    }

    public void setChunk(byte[] chunk) {
        this.chunk = chunk;
        this.modificationStartOffset = 0;
        this.modificationEndOffset = chunk.length - 1;
        this.payloadLength = chunk.length;
    }

    public int getModificationStartOffset() {
        return this.modificationStartOffset;
    }

    public void setModificationStartOffset(int modificationStartOffset) {
        if (modificationStartOffset < 0 || modificationStartOffset > this.chunk.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal modification start index: " + modificationStartOffset + " (chunk length: " + this.chunk.length + ")");
        }
        this.modificationStartOffset = modificationStartOffset;
    }

    public int getModificationEndOffset() {
        return this.modificationEndOffset;
    }

    public void setModificationEndOffset(int modificationEndOffset) {
        if (modificationEndOffset < 0 || modificationEndOffset > this.chunk.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal modification end index: " + modificationEndOffset + " (chunk length: " + this.chunk.length + ")");
        }
        this.modificationEndOffset = modificationEndOffset;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(int payloadLength) {
        if (payloadLength < 0 || payloadLength > this.chunk.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal payload length: " + payloadLength);
        }
        this.payloadLength = payloadLength;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        if (status < 0 || status > 2) {
            throw new IllegalArgumentException("Illegal status specified: " + status);
        }
        this.status = status;
    }

    public void copyLeadingData(ByteArrayOutputStream dest) {
        if (this.modificationStartOffset > 0) {
            dest.write(this.chunk, 0, this.modificationStartOffset);
        }
    }

    public void copyLeadingData(byte[] dest) {
        this.copyLeadingData(dest, 0);
    }

    public void copyLeadingData(byte[] dest, int destPos) {
        if (destPos + this.modificationStartOffset > dest.length) {
            throw new ArrayIndexOutOfBoundsException("leading data length " + this.modificationStartOffset + " excceeds destination array");
        }
        if (this.modificationStartOffset > 0) {
            System.arraycopy(this.chunk, 0, dest, destPos, this.modificationStartOffset);
        }
    }

    public void copyTrailingData(ByteArrayOutputStream dest) {
        int trailingDataLength = this.getTrailingDataLength();
        if (trailingDataLength > 0) {
            dest.write(this.chunk, this.modificationEndOffset + 1, trailingDataLength);
        }
    }

    public void copyTrailingData(byte[] dest, int destPos) {
        int trailingDataLength = this.getTrailingDataLength();
        if (destPos + trailingDataLength > dest.length) {
            throw new ArrayIndexOutOfBoundsException("trailing data length " + trailingDataLength + " excceeds destination array");
        }
        if (trailingDataLength > 0) {
            System.arraycopy(this.chunk, this.modificationEndOffset + 1, dest, destPos, trailingDataLength);
        }
    }

    public synchronized byte[] extractModificationData() {
        byte[] returnBuffer = null;
        if (this.modificationStartOffset == 0 && this.modificationEndOffset == 0) {
            returnBuffer = this.chunk;
            this.payloadLength = 0;
            this.modificationEndOffset = 0;
            this.modificationStartOffset = 0;
            this.chunk = new byte[0];
        } else {
            returnBuffer = new byte[this.getModificationDataLength()];
            System.arraycopy(this.chunk, this.modificationStartOffset, returnBuffer, 0, returnBuffer.length);
            this.payloadLength -= returnBuffer.length;
            byte[] newChunk = new byte[this.chunk.length - returnBuffer.length];
            this.copyLeadingData(newChunk);
            this.copyTrailingData(newChunk, this.modificationStartOffset);
            this.modificationEndOffset = this.modificationStartOffset;
            this.chunk = newChunk;
        }
        return returnBuffer;
    }

    public synchronized void injectModificationData(byte[] modificationData) {
        this.injectModificationData(modificationData, 0, modificationData.length);
    }

    public synchronized void injectModificationData(byte[] modificationData, int offset, int length) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset must be >= 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must be >= 0");
        }
        byte[] newChunk = new byte[this.chunk.length + length];
        this.copyLeadingData(newChunk);
        this.copyTrailingData(newChunk, this.modificationEndOffset + length);
        System.arraycopy(modificationData, offset, newChunk, this.modificationStartOffset, length);
        System.arraycopy(this.chunk, this.modificationStartOffset, newChunk, length, this.getModificationDataLength());
        this.modificationEndOffset += length;
        this.payloadLength += length;
        this.chunk = newChunk;
    }

    public int getModificationDataLength() {
        return this.modificationEndOffset - this.modificationStartOffset + 1;
    }

    public int getLeadingDataLength() {
        return this.modificationStartOffset;
    }

    public int getTrailingDataLength() {
        return this.payloadLength - (this.modificationEndOffset + 1);
    }
}

