/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.BusyFlag;

public final class CondVar {
    private BusyFlag SyncVar;

    public CondVar() {
        this(new BusyFlag());
    }

    public CondVar(BusyFlag sv) {
        this.SyncVar = sv;
    }

    public void cvWait() throws InterruptedException {
        this.cvTimedWait(this.SyncVar, 0);
    }

    public void cvWait(BusyFlag sv) throws InterruptedException {
        this.cvTimedWait(sv, 0);
    }

    public void cvTimedWait(int millis) throws InterruptedException {
        this.cvTimedWait(this.SyncVar, millis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cvTimedWait(BusyFlag sv, int millis) throws InterruptedException {
        int i = 0;
        InterruptedException errex = null;
        CondVar condVar = this;
        synchronized (condVar) {
            if (sv.getBusyFlagOwner() != Thread.currentThread()) {
                throw new IllegalMonitorStateException("current thread not owner");
            }
            while (sv.getBusyFlagOwner() == Thread.currentThread()) {
                ++i;
                sv.freeBusyFlag();
            }
            try {
                if (millis == 0) {
                    this.wait();
                } else {
                    this.wait(millis);
                }
            }
            catch (InterruptedException iex) {
                errex = iex;
            }
        }
        while (i > 0) {
            sv.getBusyFlag();
            --i;
        }
        if (errex != null) {
            throw errex;
        }
    }

    public void cvSignal() {
        this.cvSignal(this.SyncVar);
    }

    public synchronized void cvSignal(BusyFlag sv) {
        if (sv.getBusyFlagOwner() != Thread.currentThread()) {
            throw new IllegalMonitorStateException("current thread not owner");
        }
        this.notify();
    }

    public void cvBroadcast() {
        this.cvBroadcast(this.SyncVar);
    }

    public synchronized void cvBroadcast(BusyFlag sv) {
        if (sv.getBusyFlagOwner() != Thread.currentThread()) {
            throw new IllegalMonitorStateException("current thread not owner");
        }
        this.notifyAll();
    }
}

