/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractDataChain;
import anon.client.AbstractDataChannel;
import anon.client.DataChainChannelListEntry;
import anon.client.DataChainErrorListener;
import anon.client.DataChainInputStreamQueueEntry;
import anon.client.DataChainSendOrderStructure;
import anon.client.IDataChannelCreator;
import anon.client.IntegrityErrorListener;
import anon.client.InternalChannelMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class SequentialChannelDataChain
extends AbstractDataChain {
    private static final int CHAIN_ID_LENGTH = 8;
    private static final short FLAG_UNKNOWN_CHAIN_ID = 8192;
    private static final short FLAG_CONNECTION_ERROR = Short.MIN_VALUE;
    private static final short FLAG_NEW_CHAIN = 8192;
    private static final short FLAG_FAST_RESPONSE = Short.MIN_VALUE;
    private static final short FLAG_STREAM_CLOSED = 16384;
    private Vector m_associatedChannels = new Vector();
    private boolean m_firstDownstreamPacket = true;
    private volatile byte[] m_chainId;
    private int m_maximumOutputBlocksize;
    private Object m_sendSynchronization = new Object();
    private volatile boolean m_chainClosed = false;
    private long m_chainTimeout;

    public SequentialChannelDataChain(IDataChannelCreator a_channelCreator, DataChainErrorListener a_errorListener, IntegrityErrorListener a_integrityErrorListener, long a_chainTimeout) {
        super(a_channelCreator, a_errorListener, a_integrityErrorListener);
        this.m_chainTimeout = a_chainTimeout;
        AbstractDataChannel dummyChannel = this.createDataChannel();
        int channelBlocksize = dummyChannel.getNextPacketRecommandedOutputBlocksize();
        try {
            dummyChannel.organizeChannelClose();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.m_maximumOutputBlocksize = channelBlocksize - 2 + 1;
    }

    public int getOutputBlockSize() {
        return this.m_maximumOutputBlocksize;
    }

    public void createPacketPayload(DataChainSendOrderStructure a_order) {
        if (a_order.getOrderData() != null) {
            SendOrderProtocolData protocolData = (SendOrderProtocolData)a_order.getAdditionalProtocolData();
            int dataLength = 0;
            boolean firstSequelChannelPacket = false;
            if (protocolData.getChannelEntry().getProcessedUpstreamPackets() == 0 && this.m_chainId != null) {
                dataLength = Math.min(a_order.getOrderData().length, a_order.getChannelCell().length - 2 - 8);
                firstSequelChannelPacket = true;
                LogHolder.log(7, LogType.NET, "SequentialChannelDataChain: createPacketPayload(): Resuming existent chain.");
            } else {
                dataLength = Math.min(a_order.getOrderData().length, a_order.getChannelCell().length - 2);
            }
            int lengthAndFlags = dataLength;
            if (a_order.getOrderData().length > dataLength || protocolData.enforceFastResponse()) {
                lengthAndFlags |= Short.MIN_VALUE;
            }
            if (protocolData.sendUpstreamClose()) {
                lengthAndFlags |= 0x4000;
                LogHolder.log(7, LogType.NET, "SequentialChannelDataChain: createPacketPayload(): Sending STREAM_CLOSE.");
            }
            if (protocolData.getChannelEntry().getProcessedUpstreamPackets() == 0 && !firstSequelChannelPacket) {
                lengthAndFlags |= 0x2000;
                LogHolder.log(7, LogType.NET, "SequentialChannelDataChain: createPacketPayload(): Sending NEW_CHAIN.");
            }
            protocolData.getChannelEntry().incProcessedUpstreamPackets();
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            try {
                dataStream.writeShort(lengthAndFlags);
                dataStream.flush();
                if (firstSequelChannelPacket) {
                    byteStream.write(this.m_chainId);
                }
                byteStream.write(a_order.getOrderData(), 0, dataLength);
                byteStream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            System.arraycopy(byteStream.toByteArray(), 0, a_order.getChannelCell(), 0, byteStream.toByteArray().length);
            a_order.setProcessedBytes(dataLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        DataChainChannelListEntry dataChainChannelListEntry;
        try {
            DataChainChannelListEntry currentChannel = null;
            while (!Thread.interrupted()) {
                if (currentChannel == null) {
                    Vector vector = this.m_associatedChannels;
                    synchronized (vector) {
                        if (this.m_associatedChannels.size() == 0 && !this.m_firstDownstreamPacket) {
                            Thread chainKeepAliveThread = new Thread(new Runnable(){

                                public void run() {
                                    DataChainSendOrderStructure dummyOrder = new DataChainSendOrderStructure(new byte[0]);
                                    SequentialChannelDataChain.this.orderPacketInternal(dummyOrder, false, true);
                                }
                            }, "SequentialChannelDataChain: Datachain keep-alive thread");
                            chainKeepAliveThread.setDaemon(true);
                            chainKeepAliveThread.start();
                        }
                        while (this.m_associatedChannels.size() == 0) {
                            this.m_associatedChannels.wait();
                        }
                        currentChannel = (DataChainChannelListEntry)this.m_associatedChannels.firstElement();
                    }
                }
                InternalChannelMessage currentMessage = currentChannel.getChannel().getChannelMessageQueue().waitForNextMessage();
                currentChannel.getChannel().getChannelMessageQueue().removeFirstMessage();
                switch (currentMessage.getMessageCode()) {
                    case 1: {
                        ChainCell dataCell = null;
                        try {
                            dataCell = new ChainCell(currentMessage.getMessageData());
                        }
                        catch (InvalidChainCellException e) {
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException(e.toString())));
                            Thread.currentThread().interrupt();
                        }
                        if (dataCell == null) break;
                        if (dataCell.getReceivedChainId() != null) {
                            this.m_chainId = dataCell.getReceivedChainId();
                        }
                        if (dataCell.getPayloadData().length > 0) {
                            LogHolder.log(7, LogType.NET, "SequentialChannelDataChain: run(): Data received.");
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(1, dataCell.getPayloadData()));
                        }
                        if (dataCell.isUnknownChainIdFlagSet()) {
                            LogHolder.log(3, LogType.NET, "SequentialChannelDataChain: run(): Last mix signaled unknown chain ID.");
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SequentialChannelDataChain: run(): Last mix signaled unknown chain ID.")));
                        }
                        if (dataCell.isDownstreamClosedFlagSet()) {
                            LogHolder.log(7, LogType.NET, "SequentialChannelDataChain: run(): Received downstream-close flag.");
                            Thread.currentThread().interrupt();
                            break;
                        }
                        DataChainChannelListEntry e = currentChannel;
                        synchronized (e) {
                            currentChannel.incProcessedDownstreamPackets();
                            currentChannel.notify();
                            break;
                        }
                    }
                    case 2: {
                        ChainCell dataCell = null;
                        try {
                            if (currentMessage.getMessageData() != null && (dataCell = new ChainCell(currentMessage.getMessageData())).getPayloadData().length == 0 && dataCell.isConnectionErrorFlagSet()) {
                                LogHolder.log(3, LogType.NET, "SequentialChannelDataChain: run(): Last mix signaled a connection-error.");
                                this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SequentialChannelDataChain: run(): Last mix signaled a connection-error.")));
                                this.propagateConnectionError();
                            }
                        }
                        catch (InvalidChainCellException e) {
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException(e.toString())));
                        }
                        if (currentChannel.getProcessedDownstreamPackets() == 0) {
                            LogHolder.log(3, LogType.NET, "SequentialChannelDataChain: run(): Last mix sent CHANNEL_CLOSE immediately without data-packets.");
                            Thread.currentThread().interrupt();
                            break;
                        }
                        Vector vector = this.m_associatedChannels;
                        synchronized (vector) {
                            this.m_associatedChannels.removeElementAt(0);
                        }
                        currentChannel = null;
                        break;
                    }
                    case 3: {
                        this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SingleChannelDataChain: run(): Channel signaled an exception - closing chain.")));
                        dataChainChannelListEntry = currentChannel;
                        synchronized (dataChainChannelListEntry) {
                            currentChannel.notify();
                        }
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.m_chainClosed = true;
        this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(2, null));
        Vector vector = this.m_associatedChannels;
        synchronized (vector) {
            while (this.m_associatedChannels.size() > 0) {
                DataChainChannelListEntry currentChannel;
                dataChainChannelListEntry = currentChannel = (DataChainChannelListEntry)this.m_associatedChannels.firstElement();
                synchronized (dataChainChannelListEntry) {
                    currentChannel.notify();
                }
                this.m_associatedChannels.removeElementAt(0);
            }
        }
    }

    protected void orderPacket(DataChainSendOrderStructure a_order) {
        this.orderPacketInternal(a_order, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderPacketInternal(DataChainSendOrderStructure a_order, boolean a_sendUpstreamClose, boolean a_enforceFastResponse) {
        Object object = this.m_sendSynchronization;
        synchronized (object) {
            if (!this.m_chainClosed) {
                DataChainChannelListEntry lastChannel = null;
                Vector vector = this.m_associatedChannels;
                synchronized (vector) {
                    if (this.m_associatedChannels.size() > 0) {
                        lastChannel = (DataChainChannelListEntry)this.m_associatedChannels.lastElement();
                    }
                }
                boolean packetProcessed = false;
                if (lastChannel != null) {
                    a_order.setAdditionalProtocolData(new SendOrderProtocolData(lastChannel, a_sendUpstreamClose, a_enforceFastResponse));
                    packetProcessed = lastChannel.getChannel().processSendOrder(a_order);
                }
                if (!packetProcessed) {
                    if (lastChannel != null) {
                        DataChainChannelListEntry dataChainChannelListEntry = lastChannel;
                        synchronized (dataChainChannelListEntry) {
                            if (lastChannel.getProcessedDownstreamPackets() == 0) {
                                try {
                                    lastChannel.wait();
                                }
                                catch (InterruptedException e) {
                                    a_order.setThrownException(new InterruptedIOException("SequentialChannelDataChain: orderPacketInternal(): Waiting for available channel was interrupted: " + e.toString()));
                                    a_order.processingDone();
                                    return;
                                }
                                if (lastChannel.getProcessedDownstreamPackets() == 0) {
                                    a_order.setThrownException(new IOException("SequentialChannelDataChain: orderPacketInternal(): Chain already closed."));
                                    a_order.processingDone();
                                }
                            }
                        }
                    }
                    DataChainChannelListEntry sequelChannelEntry = new DataChainChannelListEntry(this.createDataChannel());
                    Vector vector2 = this.m_associatedChannels;
                    synchronized (vector2) {
                        this.m_associatedChannels.addElement(sequelChannelEntry);
                        this.m_associatedChannels.notifyAll();
                    }
                    a_order.setAdditionalProtocolData(new SendOrderProtocolData(sequelChannelEntry, a_sendUpstreamClose, a_enforceFastResponse));
                    sequelChannelEntry.getChannel().processSendOrder(a_order);
                }
            } else {
                a_order.setThrownException(new IOException("SequentialChannelDataChain: orderPacketInternal(): Chain already closed."));
                a_order.processingDone();
            }
        }
    }

    protected void outputStreamClosed() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeDataChain() {
        Object object = this.m_sendSynchronization;
        synchronized (object) {
            if (!this.m_chainClosed) {
                this.orderPacketInternal(new DataChainSendOrderStructure(new byte[0]), true, false);
                this.m_chainClosed = true;
                this.interruptDownstreamThread();
            }
        }
    }

    private class SendOrderProtocolData {
        private DataChainChannelListEntry m_channelEntry;
        private boolean m_sendUpstreamClose;
        private boolean m_enforceFastResponse;

        public SendOrderProtocolData(DataChainChannelListEntry a_channelEntry, boolean a_sendUpstreamClose, boolean a_enforceFastResponse) {
            this.m_channelEntry = a_channelEntry;
            this.m_sendUpstreamClose = a_sendUpstreamClose;
            this.m_enforceFastResponse = a_enforceFastResponse;
        }

        public DataChainChannelListEntry getChannelEntry() {
            return this.m_channelEntry;
        }

        public boolean sendUpstreamClose() {
            return this.m_sendUpstreamClose;
        }

        public boolean enforceFastResponse() {
            return this.m_enforceFastResponse;
        }
    }

    private class ChainCell {
        private static final short DATALENGTH_MASK = 1023;
        private byte[] m_payloadData;
        private byte[] m_receivedChainId;
        private boolean m_unknownChainIdFlagSet;
        private boolean m_connectionErrorFlagSet;
        private boolean m_downstreamClosedFlagSet;

        public ChainCell(byte[] a_rawData) throws InvalidChainCellException {
            if (a_rawData.length < 2) {
                throw new InvalidChainCellException("SequentialChannelDataChain: ChainCell: Constructor: Length of chaincell must be at least 2 bytes.");
            }
            int lengthAndFlagsField = 0;
            try {
                DataInputStream rawDataStream = new DataInputStream(new ByteArrayInputStream(a_rawData, 0, 2));
                lengthAndFlagsField = rawDataStream.readShort();
            }
            catch (IOException e) {
                // empty catch block
            }
            short flags = (short)(lengthAndFlagsField & 0xFFFFFC00);
            this.m_unknownChainIdFlagSet = (flags & 0x2000) == 8192;
            this.m_connectionErrorFlagSet = (flags & Short.MIN_VALUE) == Short.MIN_VALUE;
            this.m_downstreamClosedFlagSet = (flags & 0x4000) == 16384;
            int dataOffset = 2;
            int dataLength = lengthAndFlagsField & 0x3FF;
            if (SequentialChannelDataChain.this.m_firstDownstreamPacket) {
                if (a_rawData.length < dataOffset + 8 + dataLength) {
                    throw new InvalidChainCellException("SequentialChannelDataChain: ChainCell: Constructor: First downstream chaincell must contain Chain-ID.");
                }
                this.m_receivedChainId = new byte[8];
                System.arraycopy(a_rawData, dataOffset, this.m_receivedChainId, 0, 8);
                dataOffset += 8;
                SequentialChannelDataChain.this.m_firstDownstreamPacket = false;
            } else {
                if (dataOffset + dataLength > a_rawData.length) {
                    throw new InvalidChainCellException("SequentialChannelDataChain: ChainCell: Constructor: Chaincell has invalid length-field.");
                }
                this.m_receivedChainId = null;
            }
            this.m_payloadData = new byte[dataLength];
            System.arraycopy(a_rawData, dataOffset, this.m_payloadData, 0, dataLength);
        }

        public byte[] getPayloadData() {
            return this.m_payloadData;
        }

        public byte[] getReceivedChainId() {
            return this.m_receivedChainId;
        }

        public boolean isUnknownChainIdFlagSet() {
            return this.m_unknownChainIdFlagSet;
        }

        public boolean isDownstreamClosedFlagSet() {
            return this.m_downstreamClosedFlagSet;
        }

        public boolean isConnectionErrorFlagSet() {
            return this.m_connectionErrorFlagSet;
        }
    }

    private class InvalidChainCellException
    extends Exception {
        public InvalidChainCellException(String a_message) {
            super(a_message);
        }
    }
}

