/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.IASymMixCipher;
import anon.crypto.MyRSA;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.MyRSAPublicKey;
import anon.util.Base64;
import anon.util.XMLUtil;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ASymMixCipherPlainRSA
implements IASymMixCipher {
    MyRSA m_RSA = new MyRSA();
    private MyRSAPublicKey m_PublicKey = null;

    public int encrypt(byte[] from, int ifrom, byte[] to, int ito) {
        byte[] r = null;
        try {
            r = this.m_RSA.processBlock(from, ifrom, 128);
        }
        catch (Exception e) {
            return -1;
        }
        if (r.length == 128) {
            System.arraycopy(r, 0, to, ito, 128);
        } else if (r.length == 129) {
            System.arraycopy(r, 1, to, ito, 128);
        } else {
            for (int k = 0; k < 128 - r.length; ++k) {
                to[ito + k] = 0;
            }
            System.arraycopy(r, 0, to, ito + 128 - r.length, r.length);
        }
        return 128;
    }

    public int getOutputBlockSize() {
        return 128;
    }

    public int getInputBlockSize() {
        return 128;
    }

    public int getPaddingSize() {
        return 0;
    }

    public int setPublicKey(BigInteger modulus, BigInteger exponent) {
        if (modulus == null || exponent == null) {
            return -1;
        }
        this.m_PublicKey = new MyRSAPublicKey(modulus, exponent);
        try {
            this.m_RSA.init(this.m_PublicKey);
        }
        catch (Exception e) {
            return -21;
        }
        return 0;
    }

    public int setPrivateKey(BigInteger modulus, BigInteger exponent, BigInteger privateExponent, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        if (modulus == null || exponent == null || privateExponent == null || p == null || q == null || dP == null || dQ == null || qInv == null) {
            return -1;
        }
        try {
            this.m_PublicKey = new MyRSAPublicKey(modulus, exponent);
            MyRSAPrivateKey key = new MyRSAPrivateKey(modulus, exponent, privateExponent, p, q, dP, dQ, qInv);
            this.m_RSA.init(key);
        }
        catch (Exception e) {
            return -21;
        }
        return 0;
    }

    public int setPublicKey(Element xmlKey) {
        try {
            Element elemRSAKEyValue = (Element)XMLUtil.getFirstChildByName(xmlKey, "RSAKeyValue");
            BigInteger n = this.getBigIntegerFromXml(elemRSAKEyValue, "Modulus");
            BigInteger e = this.getBigIntegerFromXml(elemRSAKEyValue, "Exponent");
            return this.setPublicKey(n, e);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int setPrivateKey(Element xmlKey) {
        try {
            Element elemRSAKeyPair = null;
            elemRSAKeyPair = xmlKey.getNodeName().equals("RSAKeyPair") ? xmlKey : (Element)XMLUtil.getFirstChildByName(xmlKey, "RSAKeyPair");
            BigInteger n = this.getBigIntegerFromXml(elemRSAKeyPair, "Modulus");
            BigInteger e = this.getBigIntegerFromXml(elemRSAKeyPair, "Exponent");
            BigInteger privateExponent = this.getBigIntegerFromXml(elemRSAKeyPair, "D");
            BigInteger p = this.getBigIntegerFromXml(elemRSAKeyPair, "P");
            BigInteger q = this.getBigIntegerFromXml(elemRSAKeyPair, "Q");
            BigInteger dP = this.getBigIntegerFromXml(elemRSAKeyPair, "DP");
            BigInteger dQ = this.getBigIntegerFromXml(elemRSAKeyPair, "DQ");
            BigInteger qInv = this.getBigIntegerFromXml(elemRSAKeyPair, "InverseQ");
            return this.setPrivateKey(n, e, privateExponent, p, q, dP, dQ, qInv);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public MyRSAPublicKey getPublicKey() {
        return this.m_PublicKey;
    }

    private BigInteger getBigIntegerFromXml(Element root, String name) {
        try {
            Element child = (Element)XMLUtil.getFirstChildByName(root, name);
            String value = XMLUtil.parseValue((Node)child, (String)null);
            byte[] b = Base64.decode(value);
            return new BigInteger(1, b);
        }
        catch (Exception e) {
            return null;
        }
    }
}

