/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.X509UnknownExtension;
import anon.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Extension;

public abstract class AbstractX509Extension {
    public static final String IDENTIFIER = null;
    private static Class[] AVAILABLE_EXTENSIONS = new Class[]{class$anon$crypto$X509UnknownExtension == null ? (class$anon$crypto$X509UnknownExtension = AbstractX509Extension.class$("anon.crypto.X509UnknownExtension")) : class$anon$crypto$X509UnknownExtension, class$anon$crypto$X509SubjectKeyIdentifier == null ? (class$anon$crypto$X509SubjectKeyIdentifier = AbstractX509Extension.class$("anon.crypto.X509SubjectKeyIdentifier")) : class$anon$crypto$X509SubjectKeyIdentifier, class$anon$crypto$X509AuthorityKeyIdentifier == null ? (class$anon$crypto$X509AuthorityKeyIdentifier = AbstractX509Extension.class$("anon.crypto.X509AuthorityKeyIdentifier")) : class$anon$crypto$X509AuthorityKeyIdentifier, class$anon$crypto$X509SubjectAlternativeName == null ? (class$anon$crypto$X509SubjectAlternativeName = AbstractX509Extension.class$("anon.crypto.X509SubjectAlternativeName")) : class$anon$crypto$X509SubjectAlternativeName, class$anon$crypto$X509IssuerAlternativeName == null ? (class$anon$crypto$X509IssuerAlternativeName = AbstractX509Extension.class$("anon.crypto.X509IssuerAlternativeName")) : class$anon$crypto$X509IssuerAlternativeName, class$anon$crypto$X509BasicConstraints == null ? (class$anon$crypto$X509BasicConstraints = AbstractX509Extension.class$("anon.crypto.X509BasicConstraints")) : class$anon$crypto$X509BasicConstraints, class$anon$crypto$X509KeyUsage == null ? (class$anon$crypto$X509KeyUsage = AbstractX509Extension.class$("anon.crypto.X509KeyUsage")) : class$anon$crypto$X509KeyUsage};
    private static Vector ms_classExtensions;
    private ASN1ObjectIdentifier m_identifier;
    private boolean m_critical;
    private byte[] m_value;
    private ASN1Sequence m_extension;
    static /* synthetic */ Class class$anon$crypto$X509UnknownExtension;
    static /* synthetic */ Class class$anon$crypto$X509SubjectKeyIdentifier;
    static /* synthetic */ Class class$anon$crypto$X509AuthorityKeyIdentifier;
    static /* synthetic */ Class class$anon$crypto$X509SubjectAlternativeName;
    static /* synthetic */ Class class$anon$crypto$X509IssuerAlternativeName;
    static /* synthetic */ Class class$anon$crypto$X509BasicConstraints;
    static /* synthetic */ Class class$anon$crypto$X509KeyUsage;
    static /* synthetic */ Class class$org$bouncycastle$asn1$ASN1Sequence;

    public AbstractX509Extension(String a_identifier, boolean a_critical, byte[] a_value) {
        ASN1EncodableVector extension = new ASN1EncodableVector();
        this.m_identifier = new ASN1ObjectIdentifier(a_identifier);
        this.m_critical = a_critical;
        this.m_value = a_value;
        extension.add(this.m_identifier);
        extension.add(ASN1Boolean.getInstance(a_critical));
        extension.add(new DEROctetString(a_value));
        this.m_extension = new DERSequence(extension);
    }

    public AbstractX509Extension(ASN1Sequence a_extension) {
        int indexValue = 1;
        this.m_extension = a_extension;
        this.m_identifier = (ASN1ObjectIdentifier)a_extension.getObjectAt(0);
        if (a_extension.size() == 3) {
            this.m_critical = ((ASN1Boolean)a_extension.getObjectAt(1)).isTrue();
            indexValue = 2;
        } else {
            this.m_critical = false;
        }
        this.m_value = ((DEROctetString)a_extension.getObjectAt(indexValue)).getOctets();
    }

    static AbstractX509Extension getInstance(ASN1Encodable asn1extension) {
        ASN1Sequence extAsASN1Seq = null;
        if (asn1extension instanceof ASN1Sequence) {
            extAsASN1Seq = (ASN1Sequence)asn1extension;
        } else if (asn1extension instanceof Extension) {
            extAsASN1Seq = (ASN1Sequence)asn1extension.toASN1Primitive();
        } else {
            throw new RuntimeException("AbstractX509Extension problem --> probably incompatible changes in a new Bouncycastle Lib!");
        }
        ASN1ObjectIdentifier identifier = (ASN1ObjectIdentifier)extAsASN1Seq.getObjectAt(0);
        Object[] derSequence = new Object[]{extAsASN1Seq};
        Class[] derEncodable = new Class[1];
        Class clazz = derEncodable[0] = class$org$bouncycastle$asn1$ASN1Sequence == null ? (class$org$bouncycastle$asn1$ASN1Sequence = AbstractX509Extension.class$("org.bouncycastle.asn1.ASN1Sequence")) : class$org$bouncycastle$asn1$ASN1Sequence;
        if (ms_classExtensions == null) {
            try {
                ms_classExtensions = ClassUtil.findSubclasses(ClassUtil.getClassStatic());
            }
            catch (Throwable a_throwable) {
                LogHolder.log(2, LogType.CRYPTO, a_throwable);
            }
            if (ms_classExtensions == null) {
                ms_classExtensions = new Vector();
            }
            if (ms_classExtensions.size() < AVAILABLE_EXTENSIONS.length) {
                int level = ClassUtil.isFindSubclassesEnabled() ? 2 : 5;
                LogHolder.log(level, LogType.CRYPTO, "X509 extension classes have not been loaded automatically!");
                for (int i = 0; i < AVAILABLE_EXTENSIONS.length; ++i) {
                    if (ms_classExtensions.contains(AVAILABLE_EXTENSIONS[i])) continue;
                    ms_classExtensions.addElement(AVAILABLE_EXTENSIONS[i]);
                }
            }
        }
        Enumeration classes = ms_classExtensions.elements();
        while (classes.hasMoreElements()) {
            Class classExtension = (Class)classes.nextElement();
            try {
                if (!classExtension.getDeclaredField("IDENTIFIER").get(null).equals(identifier.getId())) continue;
                Constructor constructor = classExtension.getConstructor(derEncodable);
                return (AbstractX509Extension)constructor.newInstance(derSequence);
            }
            catch (Exception a_e) {
            }
        }
        return new X509UnknownExtension(extAsASN1Seq);
    }

    public abstract String getName();

    public final boolean isCritical() {
        return this.m_critical;
    }

    public final String getIdentifier() {
        return this.m_identifier.getId();
    }

    public final byte[] getDEROctets() {
        return this.m_value;
    }

    public final int hashCode() {
        return this.getIdentifier().hashCode();
    }

    public final boolean equals(Object a_object) {
        if (a_object == null || !(a_object instanceof AbstractX509Extension)) {
            return false;
        }
        return this.getIdentifier().equals(((AbstractX509Extension)a_object).getIdentifier());
    }

    public abstract Vector getValues();

    public final String toString() {
        return this.getName();
    }

    final ASN1Sequence getBCExtension() {
        return this.m_extension;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

