/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.SignatureVerifier;
import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.infoservice.IDistributable;
import anon.util.Base64;
import anon.util.URLCoder;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SignatureException;
import java.util.Hashtable;
import java.util.Locale;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MessageDBEntry
extends AbstractDistributableDatabaseEntry
implements IDistributable {
    public static final String XML_ELEMENT_CONTAINER_NAME = "Messages";
    public static final String XML_ELEMENT_NAME = "Message";
    public static final String HTTP_REQUEST_STRING = "/messages";
    public static final String HTTP_SERIALS_REQUEST_STRING = "/messageserials";
    public static final String PROPERTY_NAME = "messageFileName";
    public static final String POST_FILE = "/message";
    private static final String XML_TEXT = "MessageText";
    private static final String XML_URL = "MessageURL";
    private static final String XML_ATTR_LANG = "lang";
    private static final String XML_ATTR_POPUP = "popup";
    private static final String XML_ATTR_ENCODING = "encoding";
    private static final String XML_ATTR_FREE = "free";
    private static final String XML_ELEM_POPUP_TEXT = "MessagePopupText";
    private static final String ENCODING_URL = "url";
    private static final String ENCODING_BASE64 = "base64";
    private static final long TIMEOUT = 604800000L;
    private int m_externalIdentifier;
    private long m_serial;
    private long m_lastUpdate;
    private boolean m_bIsDummy;
    private boolean m_bFree;
    private boolean m_bShowPopup;
    private String m_id;
    private Element m_xmlDescription;
    private Hashtable m_hashText = new Hashtable();
    private Hashtable m_hashPopupText = new Hashtable();
    private Hashtable m_hashUrl = new Hashtable();

    public MessageDBEntry(Element a_xmlElement) throws XMLParseException, SignatureException {
        super(System.currentTimeMillis() + 604800000L);
        XMLUtil.assertNodeName(a_xmlElement, XML_ELEMENT_NAME);
        if (SignatureVerifier.getInstance().getVerifiedXml(a_xmlElement, 2) == null) {
            throw new SignatureException();
        }
        this.m_serial = XMLUtil.parseAttribute((Node)a_xmlElement, "serial", Long.MIN_VALUE);
        this.m_id = XMLUtil.parseAttribute((Node)a_xmlElement, "id", null);
        this.m_bShowPopup = XMLUtil.parseAttribute((Node)a_xmlElement, XML_ATTR_POPUP, false);
        this.m_bFree = XMLUtil.parseAttribute((Node)a_xmlElement, XML_ATTR_FREE, false);
        if (this.m_id == null) {
            throw new XMLParseException("No id given!");
        }
        this.m_bIsDummy = this.parseTextNodes(a_xmlElement.getElementsByTagName(XML_TEXT), this.m_hashText);
        if (!this.m_bIsDummy) {
            NodeList textNodes = a_xmlElement.getElementsByTagName(XML_URL);
            for (int i = 0; i < textNodes.getLength(); ++i) {
                String content = XMLUtil.parseValue(textNodes.item(i), null);
                String lang = XMLUtil.parseAttribute(textNodes.item(i), XML_ATTR_LANG, "en");
                if (content == null) continue;
                try {
                    this.m_hashUrl.put(lang, new URL(content));
                    continue;
                }
                catch (MalformedURLException ex1) {
                    // empty catch block
                }
            }
            this.parseTextNodes(a_xmlElement.getElementsByTagName(XML_ELEM_POPUP_TEXT), this.m_hashPopupText);
        }
        this.m_lastUpdate = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_xmlElement, "LastUpdate"), -1L);
        if (this.m_lastUpdate == -1L) {
            this.m_lastUpdate = System.currentTimeMillis();
        }
        this.m_xmlDescription = a_xmlElement;
    }

    public URL getURL(Locale a_locale) {
        if (a_locale == null) {
            return null;
        }
        URL url = null;
        Object hashedURL = this.m_hashUrl.get(a_locale.getLanguage());
        if (hashedURL != null && hashedURL instanceof URL) {
            url = (URL)hashedURL;
        } else {
            hashedURL = this.m_hashUrl.get("en");
            if (hashedURL != null && hashedURL instanceof URL) {
                url = (URL)hashedURL;
            }
        }
        if (url == null) {
            LogHolder.log(4, LogType.MISC, "Could not get URL for message: " + this.getText(a_locale));
        }
        return url;
    }

    public String getText(Locale a_locale) {
        return this.getText(a_locale, this.m_hashText);
    }

    public String getPopupText(Locale a_locale) {
        return this.getText(a_locale, this.m_hashPopupText);
    }

    public int getExternalIdentifier() {
        return this.m_externalIdentifier;
    }

    public void setExternalIdentifier(int a_identifier) {
        this.m_externalIdentifier = a_identifier;
    }

    public boolean isPopupShown() {
        return this.m_bShowPopup;
    }

    public boolean isForFreeCascadesOnly() {
        return this.m_bFree;
    }

    public boolean isDummy() {
        return this.m_bIsDummy;
    }

    public long getVersionNumber() {
        return this.m_serial;
    }

    public String getId() {
        return this.m_id;
    }

    public String getPostFile() {
        return POST_FILE;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public Element getXmlStructure() {
        return this.m_xmlDescription;
    }

    private String getText(Locale a_locale, Hashtable a_textHash) {
        if (a_locale == null) {
            return null;
        }
        String text = (String)a_textHash.get(a_locale.getLanguage());
        if (text == null) {
            text = (String)a_textHash.get("en");
        }
        return text;
    }

    private boolean parseTextNodes(NodeList a_textNodes, Hashtable a_nodeTable) {
        for (int i = 0; i < a_textNodes.getLength(); ++i) {
            String content = XMLUtil.parseValue(a_textNodes.item(i), null);
            String lang = XMLUtil.parseAttribute(a_textNodes.item(i), XML_ATTR_LANG, "en");
            String encoding = XMLUtil.parseAttribute(a_textNodes.item(i), XML_ATTR_ENCODING, ENCODING_BASE64);
            if (content == null || (content = encoding.equals(ENCODING_URL) ? URLCoder.decode(content) : (encoding.equals(ENCODING_BASE64) ? Base64.decodeToString(content) : null)) == null) continue;
            a_nodeTable.put(lang, content);
        }
        boolean bFoundText = a_nodeTable.size() == 0 || a_nodeTable.get("en") == null;
        return bFoundText;
    }
}

