/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.crypto.CertPathInfo;
import anon.crypto.JAPCertificate;
import anon.crypto.MultiCertPath;
import anon.crypto.MyECPublicKey;
import anon.crypto.MyRSAPublicKey;
import anon.util.CountryMapper;
import anon.util.JAPMessages;
import anon.util.Util;
import gui.CertDetailsDialog;
import gui.GUIUtils;
import gui.JAPHtmlMultiLineLabel;
import gui.MultiCertTrustGraph;
import gui.dialog.JAPDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;

public class MultiCertOverview
extends JAPDialog
implements MouseListener {
    private static final String TITLE = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_title";
    private static final String SUMMARY = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_summary";
    private static final String EXPLANATION = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_explanation";
    private static final String MSG_NUMBER_OF_CERTS_ONE = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_numberOfCertsOne";
    private static final String MSG_NUMBER_OF_CERTS_ONE_NOT_TRUSTED = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_numberOfCertsOneNotTrusted";
    private static final String MSG_NUMBER_OF_CERTS_ONE_EXPIRED = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_numberOfCertsOneExpired";
    private static final String MSG_NUMBER_OF_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_numberOfCerts";
    private static final String MSG_NUMBER_OF_TRUSTED_CERTS_ONE = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_numberOfTrustedCertsOne";
    private static final String MSG_NUMBER_OF_TRUSTED_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_numberOfTrustedCerts";
    private static final String MSG_IDENTITY_ONE = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_identityOne";
    private static final String MSG_IDENTITY = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_identity";
    private static final String MSG_SHOW_DETAILS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_details";
    private static final String MSG_SYMBOLS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_symbols";
    private static final String MSG_TRUSTED = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_trusted";
    private static final String MSG_NOT_TRUSTED = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_notTrusted";
    private static final String MSG_VALID = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_valid";
    private static final String MSG_INVALID = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_invalid";
    private static final String MSG_ROOT_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_rootCerts";
    private static final String HINT_ROOT_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_hintRootCerts";
    private static final String MSG_OP_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_opCerts";
    private static final String HINT_OP = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_hintOp";
    private static final String MSG_MIX_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_mixCerts";
    private static final String HINT_MIX = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_hintMix";
    private static final String MSG_IS_CERTS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_isCerts";
    private static final String HINT_IS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_hintIS";
    private static final String HINT_ARROW = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_hintArrow";
    private static final String HINT_CERT_DETAILS = (class$gui$MultiCertOverview == null ? (class$gui$MultiCertOverview = MultiCertOverview.class$("gui.MultiCertOverview")) : class$gui$MultiCertOverview).getName() + "_hintCertDetails";
    private static final String IMG_PATH = "certs/";
    private static final String IMG_CERT_ORANGE_OK = "certs/cert_orange_ok.png";
    private static final String IMG_CERT_ORANGE_NOK = "certs/cert_orange_nok.png";
    private static final String IMG_CERT_ORANGE_INVALID = "certs/cert_orange_invalid.png";
    private static final String IMG_CERT_ORANGE_OK_DARK = "certs/cert_orange_ok_dark.png";
    private static final String IMG_CERT_ORANGE_NOK_DARK = "certs/cert_orange_nok_dark.png";
    private static final String IMG_CERT_ORANGE_INVALID_DARK = "certs/cert_orange_invalid_dark.png";
    private static final String IMG_CERT_PURPLE_OK = "certs/cert_purple_ok.png";
    private static final String IMG_CERT_PURPLE_NOK = "certs/cert_purple_nok.png";
    private static final String IMG_CERT_PURPLE_INVALID = "certs/cert_purple_invalid.png";
    private static final String IMG_CERT_PURPLE_OK_DARK = "certs/cert_purple_ok_dark.png";
    private static final String IMG_CERT_PURPLE_NOK_DARK = "certs/cert_purple_nok_dark.png";
    private static final String IMG_CERT_PURPLE_INVALID_DARK = "certs/cert_purple_invalid_dark.png";
    private static final String IMG_CERT_BLUE_OK = "certs/cert_blue_ok.png";
    private static final String IMG_CERT_BLUE_NOK = "certs/cert_blue_nok.png";
    private static final String IMG_CERT_BLUE_INVALID = "certs/cert_blue_invalid.png";
    private static final String IMG_CERT_BLUE_OK_DARK = "certs/cert_blue_ok_dark.png";
    private static final String IMG_CERT_BLUE_NOK_DARK = "certs/cert_blue_nok_dark.png";
    private static final String IMG_CERT_BLUE_INVALID_DARK = "certs/cert_orange_invalid_dark.png";
    private static final String IMG_ARROW_NORTH = "certs/arrow_north_ok.png";
    private static final String IMG_ARROW_NORTH_NOK = "certs/arrow_north_nok.png";
    private static final String IMG_ARROW_NORTH_EAST = "certs/arrow_north_east_ok.png";
    private static final String IMG_ARROW_NORTH_EAST_NOK = "certs/arrow_north_east_nok.png";
    private static final String IMG_ARROW_NORTH_WEST = "certs/arrow_north_west_ok.png";
    private static final String IMG_ARROW_NORTH_WEST_NOK = "certs/arrow_north_west_nok.png";
    public static final String IMG_NOT_TRUSTED = "certs/not_trusted.png";
    public static final String IMG_TRUSTED = "certs/trusted_black.png";
    public static final String IMG_TRUSTED_DOUBLE = "certs/trusted_blue.png";
    public static final String IMG_TRUSTED_THREE_CERTS = "certs/trusted_green.png";
    public static final String IMG_INVALID = "certs/invalid.png";
    private static final String IMG_BOX_ORANGE = "certs/box_orange.png";
    private static final String IMG_BOX_PURPLE = "certs/box_purple.png";
    private static final String IMG_BOX_BLUE = "certs/box_blue.png";
    private MultiCertPath m_multiCertPath;
    private String m_name;
    private Hashtable m_buttonsAndNodes;
    private CertPathInfo[] m_pathInfos;
    private MultiCertTrustGraph m_graph;
    private JAPHtmlMultiLineLabel m_lblSummary;
    static /* synthetic */ Class class$gui$MultiCertOverview;

    public MultiCertOverview(Component a_parent, MultiCertPath a_multiCertPath, String a_name, boolean isInfoService) {
        super(a_parent, JAPMessages.getString(TITLE, a_name != null ? a_name : a_multiCertPath.getSubject().getCommonName()));
        this.m_multiCertPath = a_multiCertPath;
        this.m_pathInfos = this.m_multiCertPath.getPathInfos();
        this.m_graph = new MultiCertTrustGraph(this.m_pathInfos);
        this.m_name = this.m_multiCertPath.getSubject().getCommonName().startsWith("<Mix id=") && a_name != null ? a_name : this.m_multiCertPath.getSubject().getCommonName();
        this.m_buttonsAndNodes = new Hashtable();
        JPanel rootPanel = new JPanel();
        rootPanel.setLayout(new GridBagLayout());
        rootPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 2.0;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(5, 5, 5, 5);
        rootPanel.add((Component)this.drawOverviewPanel(isInfoService), c);
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel summary = this.drawSummaryPanel(isInfoService);
        tabbedPane.add(JAPMessages.getString(SUMMARY), summary);
        tabbedPane.add(JAPMessages.getString(EXPLANATION), this.drawExplanationPanel());
        c.weighty = 1.0;
        c.gridy = 2;
        rootPanel.add((Component)tabbedPane, c);
        this.getContentPane().add(rootPanel);
        this.pack();
        this.finishSummaryPanel(summary);
        this.setVisible(true);
    }

    private JPanel drawSummaryPanel(boolean isInfoService) {
        JPanel summary = new JPanel(new GridBagLayout());
        int number = this.m_multiCertPath.countPaths();
        int verified = this.m_multiCertPath.countVerifiedPaths();
        int verifiedAndValid = this.m_multiCertPath.countVerifiedAndValidPaths();
        String name = "<em>" + this.m_name + "</em>";
        String info = number <= 1 ? (verifiedAndValid == 1 ? JAPMessages.getString(MSG_NUMBER_OF_CERTS_ONE, name) : (verified == 1 ? JAPMessages.getString(MSG_NUMBER_OF_CERTS_ONE_EXPIRED, name) : JAPMessages.getString(MSG_NUMBER_OF_CERTS_ONE_NOT_TRUSTED, name))) : JAPMessages.getString(MSG_NUMBER_OF_CERTS, new Object[]{name, new Integer(number), new Integer(verifiedAndValid)});
        info = info + " ";
        if (number > 1) {
            info = verified == 1 ? info + JAPMessages.getString(MSG_NUMBER_OF_TRUSTED_CERTS_ONE) : info + JAPMessages.getString(MSG_NUMBER_OF_TRUSTED_CERTS, new Integer(verified));
        }
        int count = this.m_graph.countTrustedRootNodes();
        String organisation = !isInfoService && this.m_multiCertPath.getIssuer().getOrganisation() != null ? this.m_multiCertPath.getIssuer().getOrganisation() : (isInfoService && this.m_multiCertPath.getSubject().getOrganisation() != null ? this.m_multiCertPath.getSubject().getOrganisation() : "");
        organisation = "<em>" + organisation + "</em>";
        if (count > 0) {
            info = info + " ";
            info = count == 1 ? info + JAPMessages.getString(MSG_IDENTITY_ONE, organisation) : info + JAPMessages.getString(MSG_IDENTITY, new Object[]{organisation, String.valueOf(count)});
        }
        this.m_lblSummary = verified == 0 ? new JAPHtmlMultiLineLabel("<font color='red'>" + info + "</font>") : new JAPHtmlMultiLineLabel(info);
        return summary;
    }

    private void finishSummaryPanel(JPanel a_summary) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 20, 5, 5);
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        a_summary.add((Component)this.m_lblSummary, c);
    }

    private JPanel drawExplanationPanel() {
        JPanel explanation = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(JAPMessages.getString(MSG_SHOW_DETAILS));
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(3, 3, 3, 3);
        c.fill = 1;
        c.anchor = 18;
        c.gridheight = 2;
        c.gridwidth = 3;
        explanation.add((Component)label, c);
        label = new JLabel(JAPMessages.getString(MSG_SYMBOLS));
        c.gridy = 2;
        c.gridheight = 1;
        c.fill = 0;
        explanation.add((Component)label, c);
        label = new JLabel(GUIUtils.loadImageIcon(IMG_NOT_TRUSTED, true, false));
        label.setText(JAPMessages.getString(MSG_NOT_TRUSTED));
        c.insets.left = 7;
        c.gridy = 3;
        c.gridwidth = 1;
        explanation.add((Component)label, c);
        label = new JLabel(GUIUtils.loadImageIcon(IMG_INVALID, true, false));
        label.setText(JAPMessages.getString(MSG_INVALID));
        c.gridy = 4;
        explanation.add((Component)label, c);
        label = new JLabel(GUIUtils.loadImageIcon(IMG_BOX_PURPLE, true, false));
        label.setText("DSA");
        c.gridx = 2;
        c.gridy = 2;
        explanation.add((Component)label, c);
        label = new JLabel(GUIUtils.loadImageIcon(IMG_BOX_ORANGE, true, false));
        label.setText("RSA");
        c.gridy = 3;
        explanation.add((Component)label, c);
        label = new JLabel(GUIUtils.loadImageIcon(IMG_BOX_BLUE, true, false));
        label.setText("ECC");
        c.gridy = 4;
        explanation.add((Component)label, c);
        return explanation;
    }

    private JPanel drawOverviewPanel(boolean isInfoService) {
        JLabel label2;
        CountryMapper country;
        JPanel overview = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        Insets none = new Insets(0, 0, 0, 0);
        Insets norm = new Insets(10, 10, 10, 10);
        overview.setBorder(BorderFactory.createLoweredBevelBorder());
        overview.setBackground(Color.white);
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setBackground(Color.white);
        JLabel label = new JLabel(JAPMessages.getString(MSG_ROOT_CERTS));
        label.setToolTipText(JAPMessages.getString(HINT_ROOT_CERTS));
        panel.add(label);
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = norm;
        c.fill = 0;
        overview.add((Component)panel, c);
        panel = new JPanel(new GridLayout(2, 1));
        panel.setBackground(Color.white);
        if (isInfoService) {
            label = new JLabel(JAPMessages.getString(MSG_IS_CERTS));
            country = new CountryMapper(this.m_multiCertPath.getSubject().getCountryCode(), JAPMessages.getLocale());
            String infoservice = this.m_name;
            if (infoservice.length() > 35) {
                infoservice = infoservice.substring(0, 32) + "...";
            }
            label2 = new JLabel(infoservice, GUIUtils.loadImageIcon("flags/" + country.getISOCode() + ".png", true, false), 2);
            label2.setToolTipText(JAPMessages.getString(HINT_IS, new Object[]{this.m_name, country.toString()}));
        } else {
            label = new JLabel(JAPMessages.getString(MSG_OP_CERTS));
            country = new CountryMapper(this.m_multiCertPath.getIssuer().getCountryCode(), JAPMessages.getLocale());
            String organisation = this.m_multiCertPath.getIssuer().getOrganisation();
            if (organisation.length() > 35) {
                organisation = organisation.substring(0, 32) + "...";
            }
            label2 = new JLabel(organisation, GUIUtils.loadImageIcon("flags/" + country.getISOCode() + ".png", true, false), 2);
            label2.setToolTipText(JAPMessages.getString(HINT_OP, new Object[]{this.m_multiCertPath.getIssuer().getOrganisation(), country.toString()}));
        }
        panel.add(label);
        panel.add(label2);
        c.gridy += 2;
        overview.add((Component)panel, c);
        if (!isInfoService) {
            panel = new JPanel(new GridLayout(2, 1));
            panel.setBackground(Color.white);
            label = new JLabel(JAPMessages.getString(MSG_MIX_CERTS));
            panel.add(label);
            country = new CountryMapper(this.m_multiCertPath.getSubject().getCountryCode(), JAPMessages.getLocale());
            String mix = this.m_name;
            if (mix.length() > 35) {
                mix = mix.substring(0, 32) + "...";
            }
            label = new JLabel(mix, GUIUtils.loadImageIcon("flags/" + country.getISOCode() + ".png", true, false), 2);
            label.setToolTipText(JAPMessages.getString(HINT_MIX, new Object[]{this.m_name, country.toString()}));
            panel.add(label);
            c.gridy += 2;
            overview.add((Component)panel, c);
        }
        this.drawTrustGraph(overview);
        c.gridx = 1;
        c.gridy = 0;
        c.gridheight = 5;
        c.weighty = 1.0;
        c.insets = new Insets(5, 0, 5, 0);
        c.fill = 3;
        overview.add((Component)new JSeparator(1), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = none;
        overview.add((Component)new JSeparator(0), c);
        for (int i = 0; i < this.m_multiCertPath.getMaxLength() - 3; ++i) {
            c.gridy += 2;
            overview.add((Component)new JSeparator(0), c);
        }
        if (!isInfoService) {
            c.gridy += 2;
            overview.add((Component)new JSeparator(0), c);
        }
        return overview;
    }

    private void drawTrustGraph(JPanel parent) {
        MultiCertTrustGraph.Node node;
        int x = 2;
        Enumeration rootNodes = this.m_graph.getRootNodes();
        while (rootNodes.hasMoreElements()) {
            node = (MultiCertTrustGraph.Node)rootNodes.nextElement();
            x += this.drawSubGraph(parent, node, x, 0);
        }
        rootNodes = this.m_graph.getOperatorNodes();
        while (rootNodes.hasMoreElements()) {
            node = (MultiCertTrustGraph.Node)rootNodes.nextElement();
            x += this.drawSubGraph(parent, node, x, 2);
        }
        rootNodes = this.m_graph.getEndNodes();
        while (rootNodes.hasMoreElements()) {
            node = (MultiCertTrustGraph.Node)rootNodes.nextElement();
            x += this.drawSubGraph(parent, node, x, 4);
        }
    }

    private int drawSubGraph(JPanel parent, MultiCertTrustGraph.Node node, int x, int y) {
        int width = 0;
        int count = 0;
        if (node.hasChildNodes()) {
            Enumeration childs = node.getChildNodes();
            while (childs.hasMoreElements()) {
                MultiCertTrustGraph.Node childNode = (MultiCertTrustGraph.Node)childs.nextElement();
                width += this.drawSubGraph(parent, childNode, x + count++, y + 2);
            }
            this.drawCertPanel(parent, x, y, width, node);
            for (int i = 0; i < count; ++i) {
                int middle = Math.round((float)width / (float)(i + 1));
                if (i + 1 == middle) {
                    this.drawArrow(parent, x + i, y + 1, 1, node.isTrusted());
                    continue;
                }
                if (i + 1 > middle) {
                    this.drawArrow(parent, x + i, y + 1, 8, node.isTrusted());
                    continue;
                }
                this.drawArrow(parent, x + i, y + 1, 2, node.isTrusted());
            }
            return width;
        }
        this.drawCertPanel(parent, x, y, 1, node);
        return 1;
    }

    private void drawCertPanel(JPanel parent, int gridx, int gridy, int gridwidth, MultiCertTrustGraph.Node node) {
        JPanel certPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JAPCertificate cert = node.getCertificate();
        Color colorBackground = Color.white;
        if (cert == null) {
            return;
        }
        JButton radioButton = new JButton();
        if (cert.getPublicKey() instanceof MyRSAPublicKey) {
            if (node.isTrusted()) {
                if (cert.getValidity().isValid(new Date())) {
                    radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_OK, true, false));
                    radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_OK_DARK, true, false));
                } else {
                    radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_INVALID, true, false));
                    radioButton.setRolloverIcon(GUIUtils.loadImageIcon("certs/cert_orange_invalid_dark.png", true, false));
                }
            } else {
                radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_NOK, true, false));
                radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_ORANGE_NOK_DARK, true, false));
            }
        } else if (cert.getPublicKey() instanceof MyECPublicKey) {
            if (node.isTrusted()) {
                if (cert.getValidity().isValid(new Date())) {
                    radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_OK, true, false));
                    radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_OK_DARK, true, false));
                } else {
                    radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_INVALID, true, false));
                    radioButton.setRolloverIcon(GUIUtils.loadImageIcon("certs/cert_orange_invalid_dark.png", true, false));
                }
            } else {
                radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_NOK, true, false));
                radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_BLUE_NOK_DARK, true, false));
            }
        } else if (node.isTrusted()) {
            if (cert.getValidity().isValid(new Date())) {
                radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_OK, true, false));
                radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_OK_DARK, true, false));
            } else {
                radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_INVALID, true, false));
                radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_INVALID_DARK, true, false));
            }
        } else {
            radioButton.setIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_NOK, true, false));
            radioButton.setRolloverIcon(GUIUtils.loadImageIcon(IMG_CERT_PURPLE_NOK_DARK, true, false));
        }
        radioButton.setToolTipText(this.getToolTipText(cert));
        radioButton.setBorder(BorderFactory.createEmptyBorder());
        radioButton.setBackground(colorBackground);
        this.m_buttonsAndNodes.put(radioButton, node);
        radioButton.addMouseListener(this);
        c.anchor = 10;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        certPanel.add((Component)radioButton, c);
        certPanel.setBackground(colorBackground);
        c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 2;
        c.weightx = 3.0;
        c.weighty = 1.0;
        c.gridx = gridx;
        c.gridy = gridy;
        c.gridwidth = gridwidth;
        c.insets = new Insets(5, 10, 5, 10);
        parent.add((Component)certPanel, c);
    }

    private void drawArrow(JPanel parent, int gridx, int gridy, int orientation, boolean trusted) {
        JLabel label;
        GridBagConstraints c = new GridBagConstraints();
        if (orientation == 1) {
            label = trusted ? new JLabel(GUIUtils.loadImageIcon(IMG_ARROW_NORTH, true, false)) : new JLabel(GUIUtils.loadImageIcon(IMG_ARROW_NORTH_NOK, true, false));
        } else if (orientation == 8) {
            label = trusted ? new JLabel(GUIUtils.loadImageIcon(IMG_ARROW_NORTH_WEST, true, false)) : new JLabel(GUIUtils.loadImageIcon(IMG_ARROW_NORTH_WEST_NOK, true, false));
        } else if (orientation == 2) {
            label = trusted ? new JLabel(GUIUtils.loadImageIcon(IMG_ARROW_NORTH_EAST, true, false)) : new JLabel(GUIUtils.loadImageIcon(IMG_ARROW_NORTH_EAST_NOK, true, false));
        } else {
            return;
        }
        label.setToolTipText(JAPMessages.getString(HINT_ARROW));
        c.fill = 0;
        c.gridx = gridx;
        c.gridy = gridy;
        c.insets = new Insets(0, 0, 0, 0);
        parent.add((Component)label, c);
    }

    private String getToolTipText(JAPCertificate a_cert) {
        Object[] details = new String[]{Util.replaceAll(Util.replaceAll(a_cert.getSubject().getCommonName(), "<", "&lt;"), ">", "&gt;"), a_cert.getSubject().getOrganisation() != null ? a_cert.getSubject().getOrganisation() : "", a_cert.getIssuer().getCommonName(), a_cert.getIssuer().getOrganisation() != null ? a_cert.getIssuer().getOrganisation() : "", a_cert.getValidity().isValid(new Date()) ? JAPMessages.getString(MSG_VALID) : "<b>" + JAPMessages.getString(MSG_INVALID) + "</b>", a_cert.getValidity().getValidFrom().toString(), a_cert.getValidity().getValidTo().toString(), a_cert.getPublicKey().getAlgorithm(), String.valueOf(a_cert.getPublicKey().getKeyLength()), a_cert.getSignatureAlgorithmName()};
        return JAPMessages.getString(HINT_CERT_DETAILS, details);
    }

    public void mouseClicked(MouseEvent e) {
        if (this.m_buttonsAndNodes.containsKey(e.getSource())) {
            MultiCertTrustGraph.Node node = (MultiCertTrustGraph.Node)this.m_buttonsAndNodes.get(e.getSource());
            if (e.getClickCount() == 1) {
                CertDetailsDialog dialog = new CertDetailsDialog(this.getParentComponent(), node.getCertificate(), node.isTrusted(), JAPMessages.getLocale());
                dialog.setVisible(true);
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

