/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.DSAKeyPool;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.pay.BIConnection;
import anon.pay.IAccountListener;
import anon.pay.IBIConnectionListener;
import anon.pay.IMessageListener;
import anon.pay.IPaymentListener;
import anon.pay.PayAccount;
import anon.pay.PayMessage;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.XMLAccountCertificate;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLErrorMessage;
import anon.pay.xml.XMLGenericText;
import anon.pay.xml.XMLJapPublicKey;
import anon.util.IMiscPasswordReader;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.captcha.ICaptchaSender;
import anon.util.captcha.IImageEncodedCaptcha;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PayAccountsFile
extends Observable
implements IXMLEncodable,
IBIConnectionListener,
IMessageListener {
    public static final String XML_ELEMENT_NAME = "PayAccounts";
    public static final Integer CHANGED_AUTO_UPDATE = new Integer(0);
    private static final String XML_ATTR_IGNORE_AI_ERRORS = "ignoreAIErrorMessages";
    private static final String XML_ATTR_ENABLE_BALANCE_AUTO_UPDATE = "autoUpdateBalance";
    private static boolean m_bIsInitialized = false;
    private boolean m_bIgnoreAIAccountErrorMessages = false;
    private boolean m_bEnableBalanceAutoUpdate = true;
    private Vector m_Accounts = new Vector();
    private PayAccount m_ActiveAccount = null;
    private static PayAccountsFile ms_AccountsFile = null;
    private Vector m_paymentListeners = new Vector();
    private Vector m_messageListeners = new Vector();
    private MyAccountListener m_MyAccountListener = new MyAccountListener();
    private DSAKeyPool m_keyPool = new DSAKeyPool(ms_keyPoolSize);
    private static int ms_keyPoolSize = 1;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;

    private PayAccountsFile() {
        this.m_keyPool.start();
    }

    public static PayAccountsFile getInstance() {
        if (ms_AccountsFile == null) {
            ms_AccountsFile = new PayAccountsFile();
        }
        return ms_AccountsFile;
    }

    public AsymmetricCryptoKeyPair createAccountKeyPair() {
        return this.m_keyPool.popKeyPair();
    }

    public void setIgnoreAIAccountError(boolean bl) {
        this.m_bIgnoreAIAccountErrorMessages = bl;
    }

    public boolean isBalanceAutoUpdateEnabled() {
        return this.m_bEnableBalanceAutoUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBalanceAutoUpdateEnabled(boolean bl) {
        PayAccountsFile payAccountsFile = this;
        synchronized (payAccountsFile) {
            if (this.m_bEnableBalanceAutoUpdate != bl) {
                this.m_bEnableBalanceAutoUpdate = bl;
                this.setChanged();
            }
            this.notifyObservers(CHANGED_AUTO_UPDATE);
        }
    }

    public boolean isAIAccountErrorIgnored() {
        return this.m_bIgnoreAIAccountErrorMessages;
    }

    public boolean importAccounts(Element element, IMiscPasswordReader iMiscPasswordReader) throws XMLParseException, Exception {
        boolean bl = false;
        XMLUtil.assertNodeName(element, XML_ELEMENT_NAME);
        Element element2 = (Element)XMLUtil.getFirstChildByName(element, "Accounts");
        Node node = XMLUtil.getFirstChildByName(element2, "Account");
        while (node != null) {
            PayMessage payMessage;
            XMLBalance xMLBalance;
            PayAccount payAccount = new PayAccount((Element)node, iMiscPasswordReader);
            PayAccountsFile.getInstance().addAccount(payAccount);
            bl = true;
            if (payAccount.getAccountInfo() != null && (xMLBalance = payAccount.getAccountInfo().getBalance()) != null && (payMessage = xMLBalance.getMessage()) != null && !payMessage.getShortMessage().equals("")) {
                PayAccountsFile.getInstance().messageReceived(payMessage);
            }
            while ((node = node.getNextSibling()) != null && !(node instanceof Element)) {
            }
        }
        return bl;
    }

    public static synchronized boolean init(Element element, IMiscPasswordReader iMiscPasswordReader, boolean bl, int n) {
        if (m_bIsInitialized) {
            return false;
        }
        if (n >= 0) {
            ms_keyPoolSize = n;
        }
        if (element != null && element.getNodeName().equals(XML_ELEMENT_NAME)) {
            PayAccountsFile.getInstance().m_bIgnoreAIAccountErrorMessages = bl ? false : XMLUtil.parseAttribute((Node)element, XML_ATTR_IGNORE_AI_ERRORS, false);
            PayAccountsFile.getInstance().m_bEnableBalanceAutoUpdate = XMLUtil.parseAttribute((Node)element, XML_ATTR_ENABLE_BALANCE_AUTO_UPDATE, true);
            Element element2 = (Element)XMLUtil.getFirstChildByName(element, "ActiveAccountNumber");
            long l = Long.parseLong(XMLUtil.parseValue((Node)element2, "0"));
            try {
                PayAccountsFile.getInstance().importAccounts(element, iMiscPasswordReader);
            }
            catch (Exception exception) {
                LogHolder.log(2, LogType.PAY, exception);
                return false;
            }
            if (l > 0L) {
                Enumeration enumeration = PayAccountsFile.getInstance().m_Accounts.elements();
                while (enumeration.hasMoreElements()) {
                    PayAccount payAccount = (PayAccount)enumeration.nextElement();
                    if (payAccount.getAccountNumber() != l) continue;
                    try {
                        PayAccountsFile.getInstance().setActiveAccount(payAccount);
                    }
                    catch (Exception exception) {}
                    break;
                }
            }
        }
        PayAccountsFile.getInstance();
        m_bIsInitialized = true;
        return true;
    }

    public Element toXmlElement(Document document) {
        return this.toXmlElement(document, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element toXmlElement(Document document, String string) {
        try {
            Element element = document.createElement(XML_ELEMENT_NAME);
            element.setAttribute("version", "1.0");
            XMLUtil.setAttribute(element, XML_ATTR_IGNORE_AI_ERRORS, this.m_bIgnoreAIAccountErrorMessages);
            XMLUtil.setAttribute(element, XML_ATTR_ENABLE_BALANCE_AUTO_UPDATE, this.m_bEnableBalanceAutoUpdate);
            Element element2 = document.createElement("ActiveAccountNumber");
            XMLUtil.setValue((Node)element2, Long.toString(this.getActiveAccountNumber()));
            element.appendChild(element2);
            element2 = document.createElement("Accounts");
            element.appendChild(element2);
            PayAccountsFile payAccountsFile = this;
            synchronized (payAccountsFile) {
                for (int i = 0; i < this.m_Accounts.size(); ++i) {
                    PayAccount payAccount = (PayAccount)this.m_Accounts.elementAt(i);
                    Element element3 = payAccount.toXmlElement(document, string);
                    element2.appendChild(element3);
                }
            }
            return element;
        }
        catch (Exception exception) {
            LogHolder.log(2, LogType.PAY, "Exception while creating PayAccountsFile XML: " + exception);
            return null;
        }
    }

    public boolean hasActiveAccount() {
        return this.m_ActiveAccount != null;
    }

    public PayAccount getActiveAccount() {
        return this.m_ActiveAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveAccount(PayAccount payAccount) {
        PayAccount payAccount2 = null;
        if (payAccount != null) {
            payAccount2 = this.getAccount(payAccount.getAccountNumber(), payAccount.getPIID());
        }
        if (payAccount2 != null && payAccount2.getPrivateKey() != null) {
            this.m_ActiveAccount = payAccount2;
            Vector vector = this.m_paymentListeners;
            synchronized (vector) {
                Enumeration enumeration = this.m_paymentListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((IPaymentListener)enumeration.nextElement()).accountActivated(this.m_ActiveAccount);
                }
            }
        }
        if (payAccount2 == null) {
            this.m_ActiveAccount = null;
            Vector vector = this.m_paymentListeners;
            synchronized (vector) {
                Enumeration enumeration = this.m_paymentListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((IPaymentListener)enumeration.nextElement()).accountActivated(this.m_ActiveAccount);
                }
            }
        }
    }

    public long getActiveAccountNumber() {
        PayAccount payAccount = this.m_ActiveAccount;
        if (payAccount != null) {
            return payAccount.getAccountNumber();
        }
        return -1L;
    }

    public synchronized PayAccount getAccount(long l, String string) {
        PayAccount payAccount = null;
        Enumeration enumeration = this.m_Accounts.elements();
        while (enumeration.hasMoreElements() && ((payAccount = (PayAccount)enumeration.nextElement()).getAccountNumber() != l || string != payAccount.getPIID() && (string == null || payAccount.getPIID() == null || !string.equals(payAccount.getPIID())))) {
            payAccount = null;
        }
        return payAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAccount(PayAccount payAccount) {
        if (payAccount == null) {
            return;
        }
        PayAccount payAccount2 = null;
        Object object = this;
        synchronized (object) {
            payAccount2 = this.getAccount(payAccount.getAccountNumber(), payAccount.getPIID());
            if (payAccount2 != null) {
                PayMessage payMessage;
                for (int i = 0; i < this.m_Accounts.size(); ++i) {
                    payAccount2 = (PayAccount)this.m_Accounts.elementAt(i);
                    if (payAccount2.getAccountNumber() != payAccount.getAccountNumber()) continue;
                    this.m_Accounts.removeElementAt(i);
                    break;
                }
                if (payAccount2.getBalance() != null && (payMessage = payAccount2.getBalance().getMessage()) != null && !payMessage.getShortMessage().equals("")) {
                    this.fireMessageRemoved(payMessage);
                }
                if (this.getActiveAccount() == payAccount2) {
                    if (this.m_Accounts.size() > 0) {
                        this.setActiveAccount((PayAccount)this.m_Accounts.elementAt(0));
                    } else {
                        this.setActiveAccount(null);
                    }
                }
            }
        }
        if (payAccount2 != null) {
            object = this.m_paymentListeners;
            synchronized (object) {
                Enumeration enumeration = this.m_paymentListeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((IPaymentListener)enumeration.nextElement()).accountRemoved(payAccount2);
                }
            }
        }
    }

    public Enumeration getAccounts() {
        return ((Vector)this.m_Accounts.clone()).elements();
    }

    public static void fireKnownMessages() {
        Enumeration enumeration = PayAccountsFile.getInstance().getAccounts();
        while (enumeration.hasMoreElements()) {
            XMLBalance xMLBalance;
            PayMessage payMessage;
            PayAccount payAccount = (PayAccount)enumeration.nextElement();
            XMLAccountInfo xMLAccountInfo = payAccount.getAccountInfo();
            if (xMLAccountInfo == null || (payMessage = (xMLBalance = payAccount.getAccountInfo().getBalance()).getMessage()) == null || payMessage.getShortMessage().equals("")) continue;
            ms_AccountsFile.fireMessageReceived(payMessage);
        }
    }

    public synchronized PayAccount getAlternativeChargedAccount(String string) {
        return this.getChargedAccount(string, this.getActiveAccount());
    }

    public synchronized PayAccount getChargedAccount(String string) {
        return this.getChargedAccount(string, null);
    }

    public synchronized PayAccount getChargedAccount(String string, PayAccount payAccount) {
        if (string == null) {
            return null;
        }
        Vector vector = PayAccountsFile.getInstance().getAccounts(string);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        PayAccount payAccount2 = null;
        if (payAccount != null && !vector.contains(payAccount)) {
            payAccount = null;
        }
        if (vector.size() > 0) {
            for (int i = 0; i < vector.size() && (!(payAccount2 = (PayAccount)vector.elementAt(i)).isCharged(timestamp) || payAccount != null && payAccount == payAccount2); ++i) {
                payAccount2 = null;
            }
        }
        return payAccount2;
    }

    public synchronized Vector getAccounts(String string) {
        Vector<PayAccount> vector = new Vector<PayAccount>();
        Enumeration enumeration = this.m_Accounts.elements();
        if (string != null && string.trim().length() > 0) {
            while (enumeration.hasMoreElements()) {
                PayAccount payAccount = (PayAccount)enumeration.nextElement();
                PaymentInstanceDBEntry paymentInstanceDBEntry = payAccount.getBI();
                if (paymentInstanceDBEntry == null) {
                    LogHolder.log(3, LogType.PAY, "Payment instance for account nr. " + payAccount.getAccountNumber() + " not found!");
                    continue;
                }
                if (!paymentInstanceDBEntry.getId().equals(string)) continue;
                vector.addElement(payAccount);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addAccount(PayAccount payAccount) throws AccountAlreadyExistingException {
        boolean bl = false;
        Enumeration enumeration = this.m_Accounts.elements();
        while (enumeration.hasMoreElements()) {
            PayAccount payAccount2 = (PayAccount)enumeration.nextElement();
            if (payAccount2.getAccountNumber() != payAccount.getAccountNumber()) continue;
            throw new AccountAlreadyExistingException();
        }
        payAccount.addAccountListener(this.m_MyAccountListener);
        payAccount.addMessageListener(this);
        this.m_Accounts.addElement(payAccount);
        if (this.m_ActiveAccount == null && payAccount.getPrivateKey() != null) {
            this.m_ActiveAccount = payAccount;
            bl = true;
        }
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            IPaymentListener iPaymentListener;
            Enumeration enumeration2 = this.m_paymentListeners.elements();
            while (enumeration2.hasMoreElements()) {
                iPaymentListener = (IPaymentListener)enumeration2.nextElement();
                iPaymentListener.accountAdded(payAccount);
                if (!bl) continue;
                iPaymentListener.accountActivated(payAccount);
            }
            enumeration2 = null;
            iPaymentListener = null;
        }
    }

    public int getNumAccounts() {
        return this.m_Accounts.size();
    }

    public synchronized PayAccount getAccountAt(int n) {
        return (PayAccount)this.m_Accounts.elementAt(n);
    }

    public boolean isInitialized() {
        return m_bIsInitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaymentListener(IPaymentListener iPaymentListener) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            if (iPaymentListener != null) {
                this.m_paymentListeners.addElement(iPaymentListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaymentListener(IPaymentListener iPaymentListener) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            if (this.m_paymentListeners.contains(iPaymentListener)) {
                this.m_paymentListeners.removeElement(iPaymentListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IMessageListener iMessageListener) {
        Vector vector = this.m_messageListeners;
        synchronized (vector) {
            if (iMessageListener != null) {
                this.m_messageListeners.addElement(iMessageListener);
            }
        }
    }

    private void fireMessageReceived(PayMessage payMessage) {
        Enumeration enumeration = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IMessageListener)enumeration.nextElement()).messageReceived(payMessage);
        }
    }

    private void fireMessageRemoved(PayMessage payMessage) {
        Enumeration enumeration = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumeration.hasMoreElements()) {
            ((IMessageListener)enumeration.nextElement()).messageRemoved(payMessage);
        }
    }

    public PayAccount createAccount(PaymentInstanceDBEntry paymentInstanceDBEntry, XMLGenericText xMLGenericText) throws Exception {
        AsymmetricCryptoKeyPair asymmetricCryptoKeyPair = this.createAccountKeyPair();
        if (asymmetricCryptoKeyPair == null) {
            return null;
        }
        return this.createAccount(paymentInstanceDBEntry, asymmetricCryptoKeyPair, xMLGenericText);
    }

    public PayAccount createAccount(PaymentInstanceDBEntry paymentInstanceDBEntry, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair, XMLGenericText xMLGenericText) throws Exception {
        XMLJapPublicKey xMLJapPublicKey = new XMLJapPublicKey(asymmetricCryptoKeyPair.getPublic());
        LogHolder.log(7, LogType.PAY, "Attempting to create account at PI " + paymentInstanceDBEntry.getName());
        BIConnection bIConnection = new BIConnection(paymentInstanceDBEntry);
        bIConnection.addConnectionListener(this);
        bIConnection.connect();
        XMLAccountCertificate xMLAccountCertificate = bIConnection.registerNewAccount(xMLJapPublicKey, asymmetricCryptoKeyPair.getPrivate());
        bIConnection.disconnect();
        PayAccount payAccount = new PayAccount(xMLAccountCertificate, asymmetricCryptoKeyPair.getPrivate(), paymentInstanceDBEntry, xMLGenericText);
        this.addAccount(payAccount);
        return payAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int signalAccountRequest(MixCascade mixCascade) {
        int n = 0;
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            Enumeration enumeration = this.m_paymentListeners.elements();
            while (enumeration.hasMoreElements() && (n = ((IPaymentListener)enumeration.nextElement()).accountCertRequested(mixCascade)) == 0) {
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAccountError(XMLErrorMessage xMLErrorMessage) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            IPaymentListener iPaymentListener = null;
            Enumeration enumeration = this.m_paymentListeners.elements();
            while (enumeration.hasMoreElements()) {
                iPaymentListener = (IPaymentListener)enumeration.nextElement();
                iPaymentListener.accountError(xMLErrorMessage, this.m_bIgnoreAIAccountErrorMessages);
            }
        }
    }

    public Vector getPaymentInstances() {
        return Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PayAccountsFile.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryList();
    }

    public PaymentInstanceDBEntry getBI(String string) {
        PaymentInstanceDBEntry paymentInstanceDBEntry = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PayAccountsFile.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(string);
        return paymentInstanceDBEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotCaptcha(ICaptchaSender iCaptchaSender, IImageEncodedCaptcha iImageEncodedCaptcha) {
        Vector vector = this.m_paymentListeners;
        synchronized (vector) {
            Enumeration enumeration = this.m_paymentListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((IPaymentListener)enumeration.nextElement()).gotCaptcha(iCaptchaSender, iImageEncodedCaptcha);
            }
        }
    }

    public void messageReceived(PayMessage payMessage) {
        this.fireMessageReceived(payMessage);
    }

    public void messageRemoved(PayMessage payMessage) {
        this.fireMessageRemoved(payMessage);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MyAccountListener
    implements IAccountListener {
        private MyAccountListener() {
        }

        public void accountChanged(PayAccount payAccount) {
            Enumeration enumeration = ((Vector)PayAccountsFile.this.m_paymentListeners.clone()).elements();
            if (payAccount != null) {
                while (enumeration.hasMoreElements()) {
                    ((IPaymentListener)enumeration.nextElement()).creditChanged(payAccount);
                }
            }
        }
    }

    public static class AccountAlreadyExistingException
    extends Exception {
    }
}

