/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPrivateKey;
import anon.crypto.XMLSignature;
import anon.pay.PayMessage;
import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBalance
implements IXMLEncodable {
    private static final String DEFAULT_RATE_ENDDATE = "3000-01-01 00:00:00.00000000";
    private long m_lAccountNumber;
    private Timestamp m_Timestamp;
    private Timestamp m_ValidTime;
    private long m_lDeposit;
    private long m_lSpent;
    private Timestamp m_flatEnddate;
    private long m_volumeKBytesleft;
    private String m_message;
    private String m_messageText;
    private URL m_messageLink;
    private Document m_docTheBalance = null;

    public XMLBalance(long l, long l2, long l3, Timestamp timestamp, Timestamp timestamp2, long l4, Timestamp timestamp3, IMyPrivateKey iMyPrivateKey) {
        this.m_lDeposit = l2;
        this.m_lSpent = l3;
        this.m_Timestamp = timestamp;
        if (this.m_Timestamp == null) {
            this.m_Timestamp = new Timestamp(System.currentTimeMillis());
        }
        this.m_ValidTime = timestamp2;
        if (this.m_ValidTime == null) {
            this.m_ValidTime = Timestamp.valueOf(DEFAULT_RATE_ENDDATE);
        }
        this.m_lAccountNumber = l;
        this.m_volumeKBytesleft = l4;
        this.m_flatEnddate = timestamp3;
        if (this.m_flatEnddate == null) {
            this.m_flatEnddate = Timestamp.valueOf(DEFAULT_RATE_ENDDATE);
        }
        this.m_docTheBalance = XMLUtil.createDocument();
        this.m_docTheBalance.appendChild(this.internal_toXmlElement(this.m_docTheBalance));
        if (iMyPrivateKey != null) {
            this.sign(iMyPrivateKey);
        }
    }

    public void sign(IMyPrivateKey iMyPrivateKey) {
        try {
            XMLSignature.sign((Node)this.m_docTheBalance, iMyPrivateKey);
        }
        catch (XMLParseException xMLParseException) {
            LogHolder.log(7, LogType.PAY, "Could not sign XMLBalance");
        }
    }

    public void setMessage(PayMessage payMessage) {
        if (payMessage == null) {
            this.m_message = null;
            this.m_messageLink = null;
            this.m_messageText = null;
        } else {
            this.m_message = payMessage.getShortMessage();
            this.m_messageLink = payMessage.getMessageLink();
            this.m_messageText = payMessage.getMessageText();
        }
        this.m_docTheBalance = XMLUtil.createDocument();
        this.m_docTheBalance.appendChild(this.internal_toXmlElement(this.m_docTheBalance));
    }

    public XMLBalance(Document document) throws Exception {
        this.setValues(document.getDocumentElement());
        this.m_docTheBalance = document;
    }

    public XMLBalance(String string) throws Exception {
        Document document = XMLUtil.toXMLDocument(string);
        this.setValues(document.getDocumentElement());
        this.m_docTheBalance = document;
    }

    public XMLBalance(Element element) throws Exception {
        this.setValues(element);
        this.m_docTheBalance = XMLUtil.createDocument();
        this.m_docTheBalance.appendChild(XMLUtil.importNode(this.m_docTheBalance, element, true));
    }

    private void setValues(Element element) throws Exception {
        block17: {
            boolean bl;
            String string;
            Element element2;
            block16: {
                if (!element.getTagName().equals("Balance") || !element.getAttribute("version").equals("1.0")) {
                    throw new Exception("Balance wrong XML format");
                }
                element2 = (Element)XMLUtil.getFirstChildByName(element, "AccountNumber");
                string = XMLUtil.parseValue((Node)element2, (String)null);
                this.m_lAccountNumber = Long.parseLong(string);
                element2 = (Element)XMLUtil.getFirstChildByName(element, "Deposit");
                string = XMLUtil.parseValue((Node)element2, (String)null);
                this.m_lDeposit = Long.parseLong(string);
                element2 = (Element)XMLUtil.getFirstChildByName(element, "Spent");
                string = XMLUtil.parseValue((Node)element2, (String)null);
                this.m_lSpent = Long.parseLong(string);
                element2 = (Element)XMLUtil.getFirstChildByName(element, "BalanceInCent");
                string = XMLUtil.parseValue((Node)element2, "0");
                element2 = (Element)XMLUtil.getFirstChildByName(element, "FlatrateEnddate");
                string = XMLUtil.parseValue((Node)element2, DEFAULT_RATE_ENDDATE);
                this.m_flatEnddate = Timestamp.valueOf(string);
                element2 = (Element)XMLUtil.getFirstChildByName(element, "VolumeBytesLeft");
                this.m_volumeKBytesleft = XMLUtil.parseValue((Node)element2, 0);
                element2 = (Element)XMLUtil.getFirstChildByName(element, "Timestamp");
                string = XMLUtil.parseValue((Node)element2, (String)null);
                this.m_Timestamp = string != null ? Timestamp.valueOf(string) : new Timestamp(System.currentTimeMillis());
                element2 = (Element)XMLUtil.getFirstChildByName(element, "Validtime");
                string = XMLUtil.parseValue((Node)element2, DEFAULT_RATE_ENDDATE);
                this.m_ValidTime = Timestamp.valueOf(string);
                element2 = (Element)XMLUtil.getFirstChildByName(element, "Message");
                if (element2 != null) {
                    bl = XMLUtil.parseAttribute((Node)element2, "encoded", false);
                    if (bl) {
                        try {
                            string = XMLUtil.parseValue((Node)element2, "");
                            if (!string.equals("")) {
                                this.m_message = Base64.decodeToString(string);
                                break block16;
                            }
                            this.m_message = "";
                        }
                        catch (Exception exception) {
                            LogHolder.log(7, LogType.PAY, "Error while reading message: " + exception + ", message (Base64) was" + string + "decoded message was" + this.m_message);
                        }
                    } else {
                        this.m_message = XMLUtil.parseValue((Node)element2, "");
                    }
                }
            }
            if ((element2 = (Element)XMLUtil.getFirstChildByName(element, "MessageLink")) != null && !(string = XMLUtil.parseValue((Node)element2, "")).equals("")) {
                try {
                    this.m_messageLink = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    LogHolder.log(7, LogType.PAY, "Could not get URL from messagelink string: " + string + ", reason: " + malformedURLException);
                }
            }
            if ((element2 = (Element)XMLUtil.getFirstChildByName(element, "MessageText")) != null) {
                bl = XMLUtil.parseAttribute((Node)element2, "encoded", false);
                if (bl) {
                    try {
                        string = XMLUtil.parseValue((Node)element2, "");
                        if (!string.equals("")) {
                            this.m_messageText = Base64.decodeToString(string);
                            break block17;
                        }
                        this.m_messageText = "";
                    }
                    catch (Exception exception) {
                        LogHolder.log(7, LogType.PAY, "Error while reading message: " + exception + ", message (Base64) was" + string + "decoded message was" + this.m_message);
                    }
                } else {
                    this.m_messageText = XMLUtil.parseValue((Node)element2, "");
                }
            }
        }
    }

    private Element internal_toXmlElement(Document document) {
        String string;
        Element element = document.createElement("Balance");
        element.setAttribute("version", "1.0");
        Element element2 = document.createElement("AccountNumber");
        XMLUtil.setValue((Node)element2, this.m_lAccountNumber);
        element.appendChild(element2);
        element2 = document.createElement("Deposit");
        XMLUtil.setValue((Node)element2, this.m_lDeposit);
        element.appendChild(element2);
        element2 = document.createElement("Spent");
        XMLUtil.setValue((Node)element2, this.m_lSpent);
        element.appendChild(element2);
        element2 = document.createElement("FlatrateEnddate");
        XMLUtil.setValue((Node)element2, this.m_flatEnddate.toString());
        element.appendChild(element2);
        element2 = document.createElement("VolumeBytesLeft");
        XMLUtil.setValue((Node)element2, this.m_volumeKBytesleft);
        element.appendChild(element2);
        element2 = document.createElement("Timestamp");
        XMLUtil.setValue((Node)element2, this.m_Timestamp.toString());
        element.appendChild(element2);
        element2 = document.createElement("Validtime");
        XMLUtil.setValue((Node)element2, this.m_ValidTime.toString());
        element.appendChild(element2);
        element2 = document.createElement("Message");
        if (this.m_message != null) {
            string = Base64.encodeString(this.m_message);
            XMLUtil.setValue((Node)element2, string);
            XMLUtil.setAttribute(element2, "encoded", true);
        }
        element.appendChild(element2);
        element2 = document.createElement("MessageText");
        if (this.m_messageText != null) {
            string = Base64.encodeString(this.m_messageText);
            XMLUtil.setAttribute(element2, "encoded", true);
            XMLUtil.setValue((Node)element2, string);
        }
        element.appendChild(element2);
        element2 = document.createElement("MessageLink");
        if (this.m_messageLink != null) {
            XMLUtil.setValue((Node)element2, this.m_messageLink.toString());
        }
        element.appendChild(element2);
        return element;
    }

    public long getAccountNumber() {
        return this.m_lAccountNumber;
    }

    public long getDeposit() {
        return this.m_lDeposit;
    }

    public long getSpent() {
        return this.m_lSpent;
    }

    public long getVolumeKBytesLeft() {
        return this.m_volumeKBytesleft;
    }

    public Timestamp getFlatEnddate() {
        return this.m_flatEnddate;
    }

    public Timestamp getTimestamp() {
        return this.m_Timestamp;
    }

    public Timestamp getValidTime() {
        return this.m_ValidTime;
    }

    public PayMessage getMessage() {
        if (this.m_message == null || this.m_message.equals("")) {
            return null;
        }
        return new PayMessage(this.m_message, this.m_messageText, this.m_messageLink);
    }

    public Element toXmlElement(Document document) {
        try {
            return (Element)XMLUtil.importNode(document, this.m_docTheBalance.getDocumentElement(), true);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

