/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.address;

import anon.transport.address.AddressParameter;
import anon.transport.address.IAddress;
import anon.transport.address.MalformedURNException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Endpoint {
    protected String m_transportIdentifier;
    protected Hashtable m_paramters;

    public String getTransportIdentifier() {
        return this.m_transportIdentifier;
    }

    public static String toURN(IAddress iAddress) {
        String string = iAddress.getTransportIdentifier();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("urn:endpoint:");
        stringBuffer.append(string);
        AddressParameter[] addressParameterArray = iAddress.getAllParameters();
        int n = addressParameterArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(":");
            stringBuffer.append(addressParameterArray[i].getName());
            stringBuffer.append("(");
            stringBuffer.append(addressParameterArray[i].getValue());
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public Endpoint(String string) throws MalformedURNException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        if (stringArray.length < 3) {
            throw new MalformedURNException("A valid Endpoint needs at least 3 Components");
        }
        if (!stringArray[0].equals("urn")) {
            throw new MalformedURNException("URN must start with \"urn:\"");
        }
        if (!stringArray[1].equals("endpoint")) {
            throw new MalformedURNException("Can only handle Endpoint-Namespace. Is " + stringArray[1]);
        }
        this.m_transportIdentifier = stringArray[2];
        this.m_paramters = new Hashtable();
        int n2 = stringArray.length;
        for (n = 3; n < n2; ++n) {
            int n3 = stringArray[n].indexOf("(");
            int n4 = stringArray[n].length() - 1;
            String string2 = stringArray[n].substring(0, n3);
            String string3 = stringArray[n].substring(++n3, n4);
            this.m_paramters.put(string2, new AddressParameter(string2, string3));
        }
    }

    public String getParameter(String string) {
        AddressParameter addressParameter = (AddressParameter)this.m_paramters.get(string);
        return addressParameter == null ? null : addressParameter.getValue();
    }

    public AddressParameter[] getAllParameters() {
        AddressParameter[] addressParameterArray = new AddressParameter[this.m_paramters.size()];
        Enumeration enumeration = this.m_paramters.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            addressParameterArray[n++] = (AddressParameter)enumeration.nextElement();
        }
        return addressParameterArray;
    }
}

